/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutEventRuleRequest
extends Request {
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="EventPattern")
    @Validation(required=true)
    private List<EventPattern> eventPattern;
    @Query
    @NameInMap(value="EventType")
    private String eventType;
    @Query
    @NameInMap(value="GroupId")
    private String groupId;
    @Query
    @NameInMap(value="RuleName")
    @Validation(required=true)
    private String ruleName;
    @Query
    @NameInMap(value="SilenceTime")
    private Long silenceTime;
    @Query
    @NameInMap(value="State")
    private String state;

    private PutEventRuleRequest(Builder builder) {
        super((Request.Builder)builder);
        this.description = builder.description;
        this.eventPattern = builder.eventPattern;
        this.eventType = builder.eventType;
        this.groupId = builder.groupId;
        this.ruleName = builder.ruleName;
        this.silenceTime = builder.silenceTime;
        this.state = builder.state;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutEventRuleRequest create() {
        return PutEventRuleRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getDescription() {
        return this.description;
    }

    public List<EventPattern> getEventPattern() {
        return this.eventPattern;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Long getSilenceTime() {
        return this.silenceTime;
    }

    public String getState() {
        return this.state;
    }

    public static class EventPattern
    extends TeaModel {
        @NameInMap(value="CustomFilters")
        private String customFilters;
        @NameInMap(value="EventTypeList")
        private List<String> eventTypeList;
        @NameInMap(value="LevelList")
        private List<String> levelList;
        @NameInMap(value="NameList")
        private List<String> nameList;
        @NameInMap(value="Product")
        @Validation(required=true)
        private String product;
        @NameInMap(value="SQLFilter")
        private String SQLFilter;
        @NameInMap(value="StatusList")
        private List<String> statusList;

        private EventPattern(Builder builder) {
            this.customFilters = builder.customFilters;
            this.eventTypeList = builder.eventTypeList;
            this.levelList = builder.levelList;
            this.nameList = builder.nameList;
            this.product = builder.product;
            this.SQLFilter = builder.SQLFilter;
            this.statusList = builder.statusList;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static EventPattern create() {
            return EventPattern.builder().build();
        }

        public String getCustomFilters() {
            return this.customFilters;
        }

        public List<String> getEventTypeList() {
            return this.eventTypeList;
        }

        public List<String> getLevelList() {
            return this.levelList;
        }

        public List<String> getNameList() {
            return this.nameList;
        }

        public String getProduct() {
            return this.product;
        }

        public String getSQLFilter() {
            return this.SQLFilter;
        }

        public List<String> getStatusList() {
            return this.statusList;
        }

        public static final class Builder {
            private String customFilters;
            private List<String> eventTypeList;
            private List<String> levelList;
            private List<String> nameList;
            private String product;
            private String SQLFilter;
            private List<String> statusList;

            public Builder customFilters(String customFilters) {
                this.customFilters = customFilters;
                return this;
            }

            public Builder eventTypeList(List<String> eventTypeList) {
                this.eventTypeList = eventTypeList;
                return this;
            }

            public Builder levelList(List<String> levelList) {
                this.levelList = levelList;
                return this;
            }

            public Builder nameList(List<String> nameList) {
                this.nameList = nameList;
                return this;
            }

            public Builder product(String product) {
                this.product = product;
                return this;
            }

            public Builder SQLFilter(String SQLFilter) {
                this.SQLFilter = SQLFilter;
                return this;
            }

            public Builder statusList(List<String> statusList) {
                this.statusList = statusList;
                return this;
            }

            public EventPattern build() {
                return new EventPattern(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutEventRuleRequest, Builder> {
        private String description;
        private List<EventPattern> eventPattern;
        private String eventType;
        private String groupId;
        private String ruleName;
        private Long silenceTime;
        private String state;

        private Builder() {
        }

        private Builder(PutEventRuleRequest request) {
            super((Request)request);
            this.description = request.description;
            this.eventPattern = request.eventPattern;
            this.eventType = request.eventType;
            this.groupId = request.groupId;
            this.ruleName = request.ruleName;
            this.silenceTime = request.silenceTime;
            this.state = request.state;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder eventPattern(List<EventPattern> eventPattern) {
            this.putQueryParameter("EventPattern", eventPattern);
            this.eventPattern = eventPattern;
            return this;
        }

        public Builder eventType(String eventType) {
            this.putQueryParameter("EventType", eventType);
            this.eventType = eventType;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.putQueryParameter("RuleName", ruleName);
            this.ruleName = ruleName;
            return this;
        }

        public Builder silenceTime(Long silenceTime) {
            this.putQueryParameter("SilenceTime", silenceTime);
            this.silenceTime = silenceTime;
            return this;
        }

        public Builder state(String state) {
            this.putQueryParameter("State", state);
            this.state = state;
            return this;
        }

        public PutEventRuleRequest build() {
            return new PutEventRuleRequest(this);
        }
    }
}

