/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class PutCustomEventRequest
extends Request {
    @Query
    @NameInMap(value="EventInfo")
    @Validation(required=true)
    private List<EventInfo> eventInfo;

    private PutCustomEventRequest(Builder builder) {
        super((Request.Builder)builder);
        this.eventInfo = builder.eventInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutCustomEventRequest create() {
        return PutCustomEventRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<EventInfo> getEventInfo() {
        return this.eventInfo;
    }

    public static class EventInfo
    extends TeaModel {
        @NameInMap(value="Content")
        @Validation(required=true)
        private String content;
        @NameInMap(value="EventName")
        @Validation(required=true)
        private String eventName;
        @NameInMap(value="GroupId")
        private String groupId;
        @NameInMap(value="Time")
        private String time;

        private EventInfo(Builder builder) {
            this.content = builder.content;
            this.eventName = builder.eventName;
            this.groupId = builder.groupId;
            this.time = builder.time;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static EventInfo create() {
            return EventInfo.builder().build();
        }

        public String getContent() {
            return this.content;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getTime() {
            return this.time;
        }

        public static final class Builder {
            private String content;
            private String eventName;
            private String groupId;
            private String time;

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder eventName(String eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder groupId(String groupId) {
                this.groupId = groupId;
                return this;
            }

            public Builder time(String time) {
                this.time = time;
                return this;
            }

            public EventInfo build() {
                return new EventInfo(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<PutCustomEventRequest, Builder> {
        private List<EventInfo> eventInfo;

        private Builder() {
        }

        private Builder(PutCustomEventRequest request) {
            super((Request)request);
            this.eventInfo = request.eventInfo;
        }

        public Builder eventInfo(List<EventInfo> eventInfo) {
            this.putQueryParameter("EventInfo", eventInfo);
            this.eventInfo = eventInfo;
            return this;
        }

        public PutCustomEventRequest build() {
            return new PutCustomEventRequest(this);
        }
    }
}

