/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ModifySiteMonitorRequest
extends Request {
    @Query
    @NameInMap(value="Address")
    private String address;
    @Query
    @NameInMap(value="AlertIds")
    private String alertIds;
    @Query
    @NameInMap(value="CustomSchedule")
    private String customSchedule;
    @Query
    @NameInMap(value="Interval")
    private String interval;
    @Query
    @NameInMap(value="IntervalUnit")
    private String intervalUnit;
    @Query
    @NameInMap(value="IspCities")
    private String ispCities;
    @Query
    @NameInMap(value="OptionsJson")
    private String optionsJson;
    @Query
    @NameInMap(value="TaskId")
    @Validation(required=true)
    private String taskId;
    @Query
    @NameInMap(value="TaskName")
    private String taskName;

    private ModifySiteMonitorRequest(Builder builder) {
        super((Request.Builder)builder);
        this.address = builder.address;
        this.alertIds = builder.alertIds;
        this.customSchedule = builder.customSchedule;
        this.interval = builder.interval;
        this.intervalUnit = builder.intervalUnit;
        this.ispCities = builder.ispCities;
        this.optionsJson = builder.optionsJson;
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifySiteMonitorRequest create() {
        return ModifySiteMonitorRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAddress() {
        return this.address;
    }

    public String getAlertIds() {
        return this.alertIds;
    }

    public String getCustomSchedule() {
        return this.customSchedule;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getIntervalUnit() {
        return this.intervalUnit;
    }

    public String getIspCities() {
        return this.ispCities;
    }

    public String getOptionsJson() {
        return this.optionsJson;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static final class Builder
    extends Request.Builder<ModifySiteMonitorRequest, Builder> {
        private String address;
        private String alertIds;
        private String customSchedule;
        private String interval;
        private String intervalUnit;
        private String ispCities;
        private String optionsJson;
        private String taskId;
        private String taskName;

        private Builder() {
        }

        private Builder(ModifySiteMonitorRequest request) {
            super((Request)request);
            this.address = request.address;
            this.alertIds = request.alertIds;
            this.customSchedule = request.customSchedule;
            this.interval = request.interval;
            this.intervalUnit = request.intervalUnit;
            this.ispCities = request.ispCities;
            this.optionsJson = request.optionsJson;
            this.taskId = request.taskId;
            this.taskName = request.taskName;
        }

        public Builder address(String address) {
            this.putQueryParameter("Address", address);
            this.address = address;
            return this;
        }

        public Builder alertIds(String alertIds) {
            this.putQueryParameter("AlertIds", alertIds);
            this.alertIds = alertIds;
            return this;
        }

        public Builder customSchedule(String customSchedule) {
            this.putQueryParameter("CustomSchedule", customSchedule);
            this.customSchedule = customSchedule;
            return this;
        }

        public Builder interval(String interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder intervalUnit(String intervalUnit) {
            this.putQueryParameter("IntervalUnit", intervalUnit);
            this.intervalUnit = intervalUnit;
            return this;
        }

        public Builder ispCities(String ispCities) {
            this.putQueryParameter("IspCities", ispCities);
            this.ispCities = ispCities;
            return this;
        }

        public Builder optionsJson(String optionsJson) {
            this.putQueryParameter("OptionsJson", optionsJson);
            this.optionsJson = optionsJson;
            return this;
        }

        public Builder taskId(String taskId) {
            this.putQueryParameter("TaskId", taskId);
            this.taskId = taskId;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public ModifySiteMonitorRequest build() {
            return new ModifySiteMonitorRequest(this);
        }
    }
}

