/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ModifyHybridMonitorTaskRequest
extends Request {
    @Query
    @NameInMap(value="AttachLabels")
    private List<AttachLabels> attachLabels;
    @Query
    @NameInMap(value="CollectInterval")
    private String collectInterval;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="SLSProcessConfig")
    private SLSProcessConfig SLSProcessConfig;
    @Query
    @NameInMap(value="TaskId")
    @Validation(required=true)
    private String taskId;
    @Query
    @NameInMap(value="TaskName")
    private String taskName;

    private ModifyHybridMonitorTaskRequest(Builder builder) {
        super((Request.Builder)builder);
        this.attachLabels = builder.attachLabels;
        this.collectInterval = builder.collectInterval;
        this.description = builder.description;
        this.SLSProcessConfig = builder.SLSProcessConfig;
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyHybridMonitorTaskRequest create() {
        return ModifyHybridMonitorTaskRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<AttachLabels> getAttachLabels() {
        return this.attachLabels;
    }

    public String getCollectInterval() {
        return this.collectInterval;
    }

    public String getDescription() {
        return this.description;
    }

    public SLSProcessConfig getSLSProcessConfig() {
        return this.SLSProcessConfig;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static class SLSProcessConfig
    extends TeaModel {
        @NameInMap(value="Express")
        private List<Express> express;
        @NameInMap(value="Filter")
        private Filter filter;
        @NameInMap(value="GroupBy")
        private List<GroupBy> groupBy;
        @NameInMap(value="Statistics")
        private List<Statistics> statistics;

        private SLSProcessConfig(Builder builder) {
            this.express = builder.express;
            this.filter = builder.filter;
            this.groupBy = builder.groupBy;
            this.statistics = builder.statistics;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SLSProcessConfig create() {
            return com.aliyun.sdk.service.cms20190101.models.ModifyHybridMonitorTaskRequest$SLSProcessConfig.builder().build();
        }

        public List<Express> getExpress() {
            return this.express;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public List<GroupBy> getGroupBy() {
            return this.groupBy;
        }

        public List<Statistics> getStatistics() {
            return this.statistics;
        }

        public static final class Builder {
            private List<Express> express;
            private Filter filter;
            private List<GroupBy> groupBy;
            private List<Statistics> statistics;

            public Builder express(List<Express> express) {
                this.express = express;
                return this;
            }

            public Builder filter(Filter filter) {
                this.filter = filter;
                return this;
            }

            public Builder groupBy(List<GroupBy> groupBy) {
                this.groupBy = groupBy;
                return this;
            }

            public Builder statistics(List<Statistics> statistics) {
                this.statistics = statistics;
                return this;
            }

            public SLSProcessConfig build() {
                return new SLSProcessConfig(this);
            }
        }
    }

    public static class Statistics
    extends TeaModel {
        @NameInMap(value="Alias")
        private String alias;
        @NameInMap(value="Function")
        private String function;
        @NameInMap(value="Parameter1")
        private String parameter1;
        @NameInMap(value="Parameter2")
        private String parameter2;
        @NameInMap(value="SLSKeyName")
        private String SLSKeyName;

        private Statistics(Builder builder) {
            this.alias = builder.alias;
            this.function = builder.function;
            this.parameter1 = builder.parameter1;
            this.parameter2 = builder.parameter2;
            this.SLSKeyName = builder.SLSKeyName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Statistics create() {
            return Statistics.builder().build();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFunction() {
            return this.function;
        }

        public String getParameter1() {
            return this.parameter1;
        }

        public String getParameter2() {
            return this.parameter2;
        }

        public String getSLSKeyName() {
            return this.SLSKeyName;
        }

        public static final class Builder {
            private String alias;
            private String function;
            private String parameter1;
            private String parameter2;
            private String SLSKeyName;

            public Builder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder parameter1(String parameter1) {
                this.parameter1 = parameter1;
                return this;
            }

            public Builder parameter2(String parameter2) {
                this.parameter2 = parameter2;
                return this;
            }

            public Builder SLSKeyName(String SLSKeyName) {
                this.SLSKeyName = SLSKeyName;
                return this;
            }

            public Statistics build() {
                return new Statistics(this);
            }
        }
    }

    public static class GroupBy
    extends TeaModel {
        @NameInMap(value="Alias")
        private String alias;
        @NameInMap(value="SLSKeyName")
        private String SLSKeyName;

        private GroupBy(Builder builder) {
            this.alias = builder.alias;
            this.SLSKeyName = builder.SLSKeyName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static GroupBy create() {
            return GroupBy.builder().build();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getSLSKeyName() {
            return this.SLSKeyName;
        }

        public static final class Builder {
            private String alias;
            private String SLSKeyName;

            public Builder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public Builder SLSKeyName(String SLSKeyName) {
                this.SLSKeyName = SLSKeyName;
                return this;
            }

            public GroupBy build() {
                return new GroupBy(this);
            }
        }
    }

    public static class Filter
    extends TeaModel {
        @NameInMap(value="Filters")
        private List<Filters> filters;
        @NameInMap(value="Relation")
        private String relation;

        private Filter(Builder builder) {
            this.filters = builder.filters;
            this.relation = builder.relation;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Filter create() {
            return Filter.builder().build();
        }

        public List<Filters> getFilters() {
            return this.filters;
        }

        public String getRelation() {
            return this.relation;
        }

        public static final class Builder {
            private List<Filters> filters;
            private String relation;

            public Builder filters(List<Filters> filters) {
                this.filters = filters;
                return this;
            }

            public Builder relation(String relation) {
                this.relation = relation;
                return this;
            }

            public Filter build() {
                return new Filter(this);
            }
        }
    }

    public static class Filters
    extends TeaModel {
        @NameInMap(value="Operator")
        private String operator;
        @NameInMap(value="SLSKeyName")
        private String SLSKeyName;
        @NameInMap(value="Value")
        private String value;

        private Filters(Builder builder) {
            this.operator = builder.operator;
            this.SLSKeyName = builder.SLSKeyName;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Filters create() {
            return Filters.builder().build();
        }

        public String getOperator() {
            return this.operator;
        }

        public String getSLSKeyName() {
            return this.SLSKeyName;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String operator;
            private String SLSKeyName;
            private String value;

            public Builder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public Builder SLSKeyName(String SLSKeyName) {
                this.SLSKeyName = SLSKeyName;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Filters build() {
                return new Filters(this);
            }
        }
    }

    public static class Express
    extends TeaModel {
        @NameInMap(value="Alias")
        private String alias;
        @NameInMap(value="Express")
        private String express;

        private Express(Builder builder) {
            this.alias = builder.alias;
            this.express = builder.express;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Express create() {
            return Express.builder().build();
        }

        public String getAlias() {
            return this.alias;
        }

        public String getExpress() {
            return this.express;
        }

        public static final class Builder {
            private String alias;
            private String express;

            public Builder alias(String alias) {
                this.alias = alias;
                return this;
            }

            public Builder express(String express) {
                this.express = express;
                return this;
            }

            public Express build() {
                return new Express(this);
            }
        }
    }

    public static class AttachLabels
    extends TeaModel {
        @NameInMap(value="Name")
        private String name;
        @NameInMap(value="Value")
        private String value;

        private AttachLabels(Builder builder) {
            this.name = builder.name;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AttachLabels create() {
            return AttachLabels.builder().build();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String name;
            private String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public AttachLabels build() {
                return new AttachLabels(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ModifyHybridMonitorTaskRequest, Builder> {
        private List<AttachLabels> attachLabels;
        private String collectInterval;
        private String description;
        private SLSProcessConfig SLSProcessConfig;
        private String taskId;
        private String taskName;

        private Builder() {
        }

        private Builder(ModifyHybridMonitorTaskRequest request) {
            super((Request)request);
            this.attachLabels = request.attachLabels;
            this.collectInterval = request.collectInterval;
            this.description = request.description;
            this.SLSProcessConfig = request.SLSProcessConfig;
            this.taskId = request.taskId;
            this.taskName = request.taskName;
        }

        public Builder attachLabels(List<AttachLabels> attachLabels) {
            this.putQueryParameter("AttachLabels", attachLabels);
            this.attachLabels = attachLabels;
            return this;
        }

        public Builder collectInterval(String collectInterval) {
            this.putQueryParameter("CollectInterval", collectInterval);
            this.collectInterval = collectInterval;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder SLSProcessConfig(SLSProcessConfig SLSProcessConfig2) {
            this.putQueryParameter("SLSProcessConfig", (Object)SLSProcessConfig2);
            this.SLSProcessConfig = SLSProcessConfig2;
            return this;
        }

        public Builder taskId(String taskId) {
            this.putQueryParameter("TaskId", taskId);
            this.taskId = taskId;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public ModifyHybridMonitorTaskRequest build() {
            return new ModifyHybridMonitorTaskRequest(this);
        }
    }
}

