/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ModifyHostInfoRequest
extends Request {
    @Query
    @NameInMap(value="HostName")
    private String hostName;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;

    private ModifyHostInfoRequest(Builder builder) {
        super((Request.Builder)builder);
        this.hostName = builder.hostName;
        this.instanceId = builder.instanceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModifyHostInfoRequest create() {
        return ModifyHostInfoRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static final class Builder
    extends Request.Builder<ModifyHostInfoRequest, Builder> {
        private String hostName;
        private String instanceId;

        private Builder() {
        }

        private Builder(ModifyHostInfoRequest request) {
            super((Request)request);
            this.hostName = request.hostName;
            this.instanceId = request.instanceId;
        }

        public Builder hostName(String hostName) {
            this.putQueryParameter("HostName", hostName);
            this.hostName = hostName;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public ModifyHostInfoRequest build() {
            return new ModifyHostInfoRequest(this);
        }
    }
}

