/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeSiteMonitorLogRequest
extends Request {
    @Query
    @NameInMap(value="Browser")
    private String browser;
    @Query
    @NameInMap(value="BrowserInfo")
    private String browserInfo;
    @Query
    @NameInMap(value="City")
    private String city;
    @Query
    @NameInMap(value="Device")
    private String device;
    @Query
    @NameInMap(value="EndTime")
    private String endTime;
    @Query
    @NameInMap(value="Filter")
    private String filter;
    @Query
    @NameInMap(value="Isp")
    private String isp;
    @Query
    @NameInMap(value="Length")
    private Integer length;
    @Query
    @NameInMap(value="MetricName")
    private String metricName;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="StartTime")
    private String startTime;
    @Query
    @NameInMap(value="TaskIds")
    @Validation(required=true)
    private String taskIds;

    private DescribeSiteMonitorLogRequest(Builder builder) {
        super((Request.Builder)builder);
        this.browser = builder.browser;
        this.browserInfo = builder.browserInfo;
        this.city = builder.city;
        this.device = builder.device;
        this.endTime = builder.endTime;
        this.filter = builder.filter;
        this.isp = builder.isp;
        this.length = builder.length;
        this.metricName = builder.metricName;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.taskIds = builder.taskIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeSiteMonitorLogRequest create() {
        return DescribeSiteMonitorLogRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getBrowserInfo() {
        return this.browserInfo;
    }

    public String getCity() {
        return this.city;
    }

    public String getDevice() {
        return this.device;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getIsp() {
        return this.isp;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getTaskIds() {
        return this.taskIds;
    }

    public static final class Builder
    extends Request.Builder<DescribeSiteMonitorLogRequest, Builder> {
        private String browser;
        private String browserInfo;
        private String city;
        private String device;
        private String endTime;
        private String filter;
        private String isp;
        private Integer length;
        private String metricName;
        private String nextToken;
        private String startTime;
        private String taskIds;

        private Builder() {
        }

        private Builder(DescribeSiteMonitorLogRequest request) {
            super((Request)request);
            this.browser = request.browser;
            this.browserInfo = request.browserInfo;
            this.city = request.city;
            this.device = request.device;
            this.endTime = request.endTime;
            this.filter = request.filter;
            this.isp = request.isp;
            this.length = request.length;
            this.metricName = request.metricName;
            this.nextToken = request.nextToken;
            this.startTime = request.startTime;
            this.taskIds = request.taskIds;
        }

        public Builder browser(String browser) {
            this.putQueryParameter("Browser", browser);
            this.browser = browser;
            return this;
        }

        public Builder browserInfo(String browserInfo) {
            this.putQueryParameter("BrowserInfo", browserInfo);
            this.browserInfo = browserInfo;
            return this;
        }

        public Builder city(String city) {
            this.putQueryParameter("City", city);
            this.city = city;
            return this;
        }

        public Builder device(String device) {
            this.putQueryParameter("Device", device);
            this.device = device;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder filter(String filter) {
            this.putQueryParameter("Filter", filter);
            this.filter = filter;
            return this;
        }

        public Builder isp(String isp) {
            this.putQueryParameter("Isp", isp);
            this.isp = isp;
            return this;
        }

        public Builder length(Integer length) {
            this.putQueryParameter("Length", length);
            this.length = length;
            return this;
        }

        public Builder metricName(String metricName) {
            this.putQueryParameter("MetricName", metricName);
            this.metricName = metricName;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder taskIds(String taskIds) {
            this.putQueryParameter("TaskIds", taskIds);
            this.taskIds = taskIds;
            return this;
        }

        public DescribeSiteMonitorLogRequest build() {
            return new DescribeSiteMonitorLogRequest(this);
        }
    }
}

