/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeMonitorGroupInstancesRequest
extends Request {
    @Query
    @NameInMap(value="Category")
    private String category;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private Long groupId;
    @Query
    @NameInMap(value="InstanceIds")
    private String instanceIds;
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;

    private DescribeMonitorGroupInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.category = builder.category;
        this.groupId = builder.groupId;
        this.instanceIds = builder.instanceIds;
        this.keyword = builder.keyword;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeMonitorGroupInstancesRequest create() {
        return DescribeMonitorGroupInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCategory() {
        return this.category;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getInstanceIds() {
        return this.instanceIds;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<DescribeMonitorGroupInstancesRequest, Builder> {
        private String category;
        private Long groupId;
        private String instanceIds;
        private String keyword;
        private Integer pageNumber;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(DescribeMonitorGroupInstancesRequest request) {
            super((Request)request);
            this.category = request.category;
            this.groupId = request.groupId;
            this.instanceIds = request.instanceIds;
            this.keyword = request.keyword;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder category(String category) {
            this.putQueryParameter("Category", category);
            this.category = category;
            return this;
        }

        public Builder groupId(Long groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder instanceIds(String instanceIds) {
            this.putQueryParameter("InstanceIds", instanceIds);
            this.instanceIds = instanceIds;
            return this;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public DescribeMonitorGroupInstancesRequest build() {
            return new DescribeMonitorGroupInstancesRequest(this);
        }
    }
}

