/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class DescribeHybridMonitorTaskListRequest
extends Request {
    @Query
    @NameInMap(value="GroupId")
    private String groupId;
    @Query
    @NameInMap(value="IncludeAliyunTask")
    private Boolean includeAliyunTask;
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="Namespace")
    private String namespace;
    @Query
    @NameInMap(value="PageNumber")
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    private Integer pageSize;
    @Query
    @NameInMap(value="TargetUserId")
    private Long targetUserId;
    @Query
    @NameInMap(value="TaskId")
    private String taskId;
    @Query
    @NameInMap(value="TaskType")
    private String taskType;

    private DescribeHybridMonitorTaskListRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupId = builder.groupId;
        this.includeAliyunTask = builder.includeAliyunTask;
        this.keyword = builder.keyword;
        this.namespace = builder.namespace;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
        this.targetUserId = builder.targetUserId;
        this.taskId = builder.taskId;
        this.taskType = builder.taskType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DescribeHybridMonitorTaskListRequest create() {
        return DescribeHybridMonitorTaskListRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Boolean getIncludeAliyunTask() {
        return this.includeAliyunTask;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTargetUserId() {
        return this.targetUserId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public static final class Builder
    extends Request.Builder<DescribeHybridMonitorTaskListRequest, Builder> {
        private String groupId;
        private Boolean includeAliyunTask;
        private String keyword;
        private String namespace;
        private Integer pageNumber;
        private Integer pageSize;
        private Long targetUserId;
        private String taskId;
        private String taskType;

        private Builder() {
        }

        private Builder(DescribeHybridMonitorTaskListRequest request) {
            super((Request)request);
            this.groupId = request.groupId;
            this.includeAliyunTask = request.includeAliyunTask;
            this.keyword = request.keyword;
            this.namespace = request.namespace;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
            this.targetUserId = request.targetUserId;
            this.taskId = request.taskId;
            this.taskType = request.taskType;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder includeAliyunTask(Boolean includeAliyunTask) {
            this.putQueryParameter("IncludeAliyunTask", includeAliyunTask);
            this.includeAliyunTask = includeAliyunTask;
            return this;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder namespace(String namespace) {
            this.putQueryParameter("Namespace", namespace);
            this.namespace = namespace;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder targetUserId(Long targetUserId) {
            this.putQueryParameter("TargetUserId", targetUserId);
            this.targetUserId = targetUserId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.putQueryParameter("TaskId", taskId);
            this.taskId = taskId;
            return this;
        }

        public Builder taskType(String taskType) {
            this.putQueryParameter("TaskType", taskType);
            this.taskType = taskType;
            return this;
        }

        public DescribeHybridMonitorTaskListRequest build() {
            return new DescribeHybridMonitorTaskListRequest(this);
        }
    }
}

