/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import com.aliyun.sdk.service.cms20190101.models.Matcher;
import java.util.List;

public class CursorRequest
extends Request {
    @Body
    @NameInMap(value="EndTime")
    private String endTime;
    @Body
    @NameInMap(value="Matchers")
    private List<Matcher> matchers;
    @Body
    @NameInMap(value="Metric")
    @Validation(required=true)
    private String metric;
    @Body
    @NameInMap(value="Namespace")
    @Validation(required=true)
    private String namespace;
    @Body
    @NameInMap(value="Period")
    @Validation(required=true)
    private Integer period;
    @Body
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;

    private CursorRequest(Builder builder) {
        super((Request.Builder)builder);
        this.endTime = builder.endTime;
        this.matchers = builder.matchers;
        this.metric = builder.metric;
        this.namespace = builder.namespace;
        this.period = builder.period;
        this.startTime = builder.startTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CursorRequest create() {
        return CursorRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEndTime() {
        return this.endTime;
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public static final class Builder
    extends Request.Builder<CursorRequest, Builder> {
        private String endTime;
        private List<Matcher> matchers;
        private String metric;
        private String namespace;
        private Integer period;
        private String startTime;

        private Builder() {
        }

        private Builder(CursorRequest request) {
            super((Request)request);
            this.endTime = request.endTime;
            this.matchers = request.matchers;
            this.metric = request.metric;
            this.namespace = request.namespace;
            this.period = request.period;
            this.startTime = request.startTime;
        }

        public Builder endTime(String endTime) {
            this.putBodyParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder matchers(List<Matcher> matchers) {
            String matchersShrink = this.shrink(matchers, "Matchers", "json");
            this.putBodyParameter("Matchers", matchersShrink);
            this.matchers = matchers;
            return this;
        }

        public Builder metric(String metric) {
            this.putBodyParameter("Metric", metric);
            this.metric = metric;
            return this;
        }

        public Builder namespace(String namespace) {
            this.putBodyParameter("Namespace", namespace);
            this.namespace = namespace;
            return this;
        }

        public Builder period(Integer period) {
            this.putBodyParameter("Period", period);
            this.period = period;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putBodyParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public CursorRequest build() {
            return new CursorRequest(this);
        }
    }
}

