/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateSiteMonitorRequest
extends Request {
    @Query
    @NameInMap(value="Address")
    @Validation(required=true)
    private String address;
    @Query
    @NameInMap(value="AlertIds")
    private String alertIds;
    @Query
    @NameInMap(value="CustomSchedule")
    private String customSchedule;
    @Query
    @NameInMap(value="Interval")
    private String interval;
    @Query
    @NameInMap(value="IspCities")
    private String ispCities;
    @Query
    @NameInMap(value="OptionsJson")
    private String optionsJson;
    @Query
    @NameInMap(value="TaskName")
    @Validation(required=true)
    private String taskName;
    @Query
    @NameInMap(value="TaskType")
    @Validation(required=true)
    private String taskType;

    private CreateSiteMonitorRequest(Builder builder) {
        super((Request.Builder)builder);
        this.address = builder.address;
        this.alertIds = builder.alertIds;
        this.customSchedule = builder.customSchedule;
        this.interval = builder.interval;
        this.ispCities = builder.ispCities;
        this.optionsJson = builder.optionsJson;
        this.taskName = builder.taskName;
        this.taskType = builder.taskType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateSiteMonitorRequest create() {
        return CreateSiteMonitorRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAddress() {
        return this.address;
    }

    public String getAlertIds() {
        return this.alertIds;
    }

    public String getCustomSchedule() {
        return this.customSchedule;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getIspCities() {
        return this.ispCities;
    }

    public String getOptionsJson() {
        return this.optionsJson;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public static final class Builder
    extends Request.Builder<CreateSiteMonitorRequest, Builder> {
        private String address;
        private String alertIds;
        private String customSchedule;
        private String interval;
        private String ispCities;
        private String optionsJson;
        private String taskName;
        private String taskType;

        private Builder() {
        }

        private Builder(CreateSiteMonitorRequest request) {
            super((Request)request);
            this.address = request.address;
            this.alertIds = request.alertIds;
            this.customSchedule = request.customSchedule;
            this.interval = request.interval;
            this.ispCities = request.ispCities;
            this.optionsJson = request.optionsJson;
            this.taskName = request.taskName;
            this.taskType = request.taskType;
        }

        public Builder address(String address) {
            this.putQueryParameter("Address", address);
            this.address = address;
            return this;
        }

        public Builder alertIds(String alertIds) {
            this.putQueryParameter("AlertIds", alertIds);
            this.alertIds = alertIds;
            return this;
        }

        public Builder customSchedule(String customSchedule) {
            this.putQueryParameter("CustomSchedule", customSchedule);
            this.customSchedule = customSchedule;
            return this;
        }

        public Builder interval(String interval) {
            this.putQueryParameter("Interval", interval);
            this.interval = interval;
            return this;
        }

        public Builder ispCities(String ispCities) {
            this.putQueryParameter("IspCities", ispCities);
            this.ispCities = ispCities;
            return this;
        }

        public Builder optionsJson(String optionsJson) {
            this.putQueryParameter("OptionsJson", optionsJson);
            this.optionsJson = optionsJson;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public Builder taskType(String taskType) {
            this.putQueryParameter("TaskType", taskType);
            this.taskType = taskType;
            return this;
        }

        public CreateSiteMonitorRequest build() {
            return new CreateSiteMonitorRequest(this);
        }
    }
}

