/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateMonitorGroupInstancesRequest
extends Request {
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="Instances")
    @Validation(required=true)
    private List<Instances> instances;

    private CreateMonitorGroupInstancesRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupId = builder.groupId;
        this.instances = builder.instances;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateMonitorGroupInstancesRequest create() {
        return CreateMonitorGroupInstancesRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<Instances> getInstances() {
        return this.instances;
    }

    public static class Instances
    extends TeaModel {
        @NameInMap(value="Category")
        @Validation(required=true)
        private String category;
        @NameInMap(value="InstanceId")
        @Validation(required=true)
        private String instanceId;
        @NameInMap(value="InstanceName")
        @Validation(required=true)
        private String instanceName;
        @NameInMap(value="RegionId")
        @Validation(required=true)
        private String regionId;

        private Instances(Builder builder) {
            this.category = builder.category;
            this.instanceId = builder.instanceId;
            this.instanceName = builder.instanceName;
            this.regionId = builder.regionId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Instances create() {
            return Instances.builder().build();
        }

        public String getCategory() {
            return this.category;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public static final class Builder {
            private String category;
            private String instanceId;
            private String instanceName;
            private String regionId;

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder instanceId(String instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public Builder instanceName(String instanceName) {
                this.instanceName = instanceName;
                return this;
            }

            public Builder regionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            public Instances build() {
                return new Instances(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateMonitorGroupInstancesRequest, Builder> {
        private String groupId;
        private List<Instances> instances;

        private Builder() {
        }

        private Builder(CreateMonitorGroupInstancesRequest request) {
            super((Request)request);
            this.groupId = request.groupId;
            this.instances = request.instances;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder instances(List<Instances> instances) {
            this.putQueryParameter("Instances", instances);
            this.instances = instances;
            return this;
        }

        public CreateMonitorGroupInstancesRequest build() {
            return new CreateMonitorGroupInstancesRequest(this);
        }
    }
}

