/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateInstantSiteMonitorRequest
extends Request {
    @Query
    @NameInMap(value="Address")
    @Validation(required=true)
    private String address;
    @Query
    @NameInMap(value="IspCities")
    private String ispCities;
    @Query
    @NameInMap(value="OptionsJson")
    private String optionsJson;
    @Query
    @NameInMap(value="RandomIspCity")
    private Integer randomIspCity;
    @Query
    @NameInMap(value="TaskName")
    @Validation(required=true)
    private String taskName;
    @Query
    @NameInMap(value="TaskType")
    @Validation(required=true)
    private String taskType;

    private CreateInstantSiteMonitorRequest(Builder builder) {
        super((Request.Builder)builder);
        this.address = builder.address;
        this.ispCities = builder.ispCities;
        this.optionsJson = builder.optionsJson;
        this.randomIspCity = builder.randomIspCity;
        this.taskName = builder.taskName;
        this.taskType = builder.taskType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateInstantSiteMonitorRequest create() {
        return CreateInstantSiteMonitorRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAddress() {
        return this.address;
    }

    public String getIspCities() {
        return this.ispCities;
    }

    public String getOptionsJson() {
        return this.optionsJson;
    }

    public Integer getRandomIspCity() {
        return this.randomIspCity;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public static final class Builder
    extends Request.Builder<CreateInstantSiteMonitorRequest, Builder> {
        private String address;
        private String ispCities;
        private String optionsJson;
        private Integer randomIspCity;
        private String taskName;
        private String taskType;

        private Builder() {
        }

        private Builder(CreateInstantSiteMonitorRequest request) {
            super((Request)request);
            this.address = request.address;
            this.ispCities = request.ispCities;
            this.optionsJson = request.optionsJson;
            this.randomIspCity = request.randomIspCity;
            this.taskName = request.taskName;
            this.taskType = request.taskType;
        }

        public Builder address(String address) {
            this.putQueryParameter("Address", address);
            this.address = address;
            return this;
        }

        public Builder ispCities(String ispCities) {
            this.putQueryParameter("IspCities", ispCities);
            this.ispCities = ispCities;
            return this;
        }

        public Builder optionsJson(String optionsJson) {
            this.putQueryParameter("OptionsJson", optionsJson);
            this.optionsJson = optionsJson;
            return this;
        }

        public Builder randomIspCity(Integer randomIspCity) {
            this.putQueryParameter("RandomIspCity", randomIspCity);
            this.randomIspCity = randomIspCity;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public Builder taskType(String taskType) {
            this.putQueryParameter("TaskType", taskType);
            this.taskType = taskType;
            return this;
        }

        public CreateInstantSiteMonitorRequest build() {
            return new CreateInstantSiteMonitorRequest(this);
        }
    }
}

