/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateHostAvailabilityRequest
extends Request {
    @Query
    @NameInMap(value="AlertConfig")
    private AlertConfig alertConfig;
    @Query
    @NameInMap(value="TaskOption")
    private TaskOption taskOption;
    @Query
    @NameInMap(value="AlertConfigEscalationList")
    @Validation(required=true)
    private List<AlertConfigEscalationList> alertConfigEscalationList;
    @Query
    @NameInMap(value="AlertConfigTargetList")
    private List<AlertConfigTargetList> alertConfigTargetList;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private Long groupId;
    @Query
    @NameInMap(value="InstanceList")
    private List<String> instanceList;
    @Query
    @NameInMap(value="TaskName")
    @Validation(required=true)
    private String taskName;
    @Query
    @NameInMap(value="TaskScope")
    private String taskScope;
    @Query
    @NameInMap(value="TaskType")
    @Validation(required=true)
    private String taskType;

    private CreateHostAvailabilityRequest(Builder builder) {
        super((Request.Builder)builder);
        this.alertConfig = builder.alertConfig;
        this.taskOption = builder.taskOption;
        this.alertConfigEscalationList = builder.alertConfigEscalationList;
        this.alertConfigTargetList = builder.alertConfigTargetList;
        this.groupId = builder.groupId;
        this.instanceList = builder.instanceList;
        this.taskName = builder.taskName;
        this.taskScope = builder.taskScope;
        this.taskType = builder.taskType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateHostAvailabilityRequest create() {
        return CreateHostAvailabilityRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public AlertConfig getAlertConfig() {
        return this.alertConfig;
    }

    public TaskOption getTaskOption() {
        return this.taskOption;
    }

    public List<AlertConfigEscalationList> getAlertConfigEscalationList() {
        return this.alertConfigEscalationList;
    }

    public List<AlertConfigTargetList> getAlertConfigTargetList() {
        return this.alertConfigTargetList;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public List<String> getInstanceList() {
        return this.instanceList;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskScope() {
        return this.taskScope;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public static class AlertConfigTargetList
    extends TeaModel {
        @NameInMap(value="Arn")
        private String arn;
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="JsonParams")
        private String jsonParams;
        @NameInMap(value="Level")
        private String level;

        private AlertConfigTargetList(Builder builder) {
            this.arn = builder.arn;
            this.id = builder.id;
            this.jsonParams = builder.jsonParams;
            this.level = builder.level;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfigTargetList create() {
            return AlertConfigTargetList.builder().build();
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public String getJsonParams() {
            return this.jsonParams;
        }

        public String getLevel() {
            return this.level;
        }

        public static final class Builder {
            private String arn;
            private String id;
            private String jsonParams;
            private String level;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder jsonParams(String jsonParams) {
                this.jsonParams = jsonParams;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public AlertConfigTargetList build() {
                return new AlertConfigTargetList(this);
            }
        }
    }

    public static class AlertConfigEscalationList
    extends TeaModel {
        @NameInMap(value="Aggregate")
        private String aggregate;
        @NameInMap(value="MetricName")
        @Validation(required=true)
        private String metricName;
        @NameInMap(value="Operator")
        private String operator;
        @NameInMap(value="Times")
        private Integer times;
        @NameInMap(value="Value")
        private String value;

        private AlertConfigEscalationList(Builder builder) {
            this.aggregate = builder.aggregate;
            this.metricName = builder.metricName;
            this.operator = builder.operator;
            this.times = builder.times;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfigEscalationList create() {
            return AlertConfigEscalationList.builder().build();
        }

        public String getAggregate() {
            return this.aggregate;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getOperator() {
            return this.operator;
        }

        public Integer getTimes() {
            return this.times;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String aggregate;
            private String metricName;
            private String operator;
            private Integer times;
            private String value;

            public Builder aggregate(String aggregate) {
                this.aggregate = aggregate;
                return this;
            }

            public Builder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public Builder operator(String operator) {
                this.operator = operator;
                return this;
            }

            public Builder times(Integer times) {
                this.times = times;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public AlertConfigEscalationList build() {
                return new AlertConfigEscalationList(this);
            }
        }
    }

    public static class TaskOption
    extends TeaModel {
        @NameInMap(value="HttpHeader")
        private String httpHeader;
        @NameInMap(value="HttpMethod")
        private String httpMethod;
        @NameInMap(value="HttpNegative")
        private Boolean httpNegative;
        @NameInMap(value="HttpPostContent")
        private String httpPostContent;
        @NameInMap(value="HttpResponseCharset")
        private String httpResponseCharset;
        @NameInMap(value="HttpResponseMatchContent")
        private String httpResponseMatchContent;
        @NameInMap(value="HttpURI")
        private String httpURI;
        @NameInMap(value="Interval")
        private Integer interval;
        @NameInMap(value="TelnetOrPingHost")
        private String telnetOrPingHost;

        private TaskOption(Builder builder) {
            this.httpHeader = builder.httpHeader;
            this.httpMethod = builder.httpMethod;
            this.httpNegative = builder.httpNegative;
            this.httpPostContent = builder.httpPostContent;
            this.httpResponseCharset = builder.httpResponseCharset;
            this.httpResponseMatchContent = builder.httpResponseMatchContent;
            this.httpURI = builder.httpURI;
            this.interval = builder.interval;
            this.telnetOrPingHost = builder.telnetOrPingHost;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TaskOption create() {
            return TaskOption.builder().build();
        }

        public String getHttpHeader() {
            return this.httpHeader;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public Boolean getHttpNegative() {
            return this.httpNegative;
        }

        public String getHttpPostContent() {
            return this.httpPostContent;
        }

        public String getHttpResponseCharset() {
            return this.httpResponseCharset;
        }

        public String getHttpResponseMatchContent() {
            return this.httpResponseMatchContent;
        }

        public String getHttpURI() {
            return this.httpURI;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public String getTelnetOrPingHost() {
            return this.telnetOrPingHost;
        }

        public static final class Builder {
            private String httpHeader;
            private String httpMethod;
            private Boolean httpNegative;
            private String httpPostContent;
            private String httpResponseCharset;
            private String httpResponseMatchContent;
            private String httpURI;
            private Integer interval;
            private String telnetOrPingHost;

            public Builder httpHeader(String httpHeader) {
                this.httpHeader = httpHeader;
                return this;
            }

            public Builder httpMethod(String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            public Builder httpNegative(Boolean httpNegative) {
                this.httpNegative = httpNegative;
                return this;
            }

            public Builder httpPostContent(String httpPostContent) {
                this.httpPostContent = httpPostContent;
                return this;
            }

            public Builder httpResponseCharset(String httpResponseCharset) {
                this.httpResponseCharset = httpResponseCharset;
                return this;
            }

            public Builder httpResponseMatchContent(String httpResponseMatchContent) {
                this.httpResponseMatchContent = httpResponseMatchContent;
                return this;
            }

            public Builder httpURI(String httpURI) {
                this.httpURI = httpURI;
                return this;
            }

            public Builder interval(Integer interval) {
                this.interval = interval;
                return this;
            }

            public Builder telnetOrPingHost(String telnetOrPingHost) {
                this.telnetOrPingHost = telnetOrPingHost;
                return this;
            }

            public TaskOption build() {
                return new TaskOption(this);
            }
        }
    }

    public static class AlertConfig
    extends TeaModel {
        @NameInMap(value="EndTime")
        private Integer endTime;
        @NameInMap(value="NotifyType")
        @Validation(required=true)
        private Integer notifyType;
        @NameInMap(value="SilenceTime")
        private Integer silenceTime;
        @NameInMap(value="StartTime")
        private Integer startTime;
        @NameInMap(value="WebHook")
        private String webHook;

        private AlertConfig(Builder builder) {
            this.endTime = builder.endTime;
            this.notifyType = builder.notifyType;
            this.silenceTime = builder.silenceTime;
            this.startTime = builder.startTime;
            this.webHook = builder.webHook;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfig create() {
            return AlertConfig.builder().build();
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public Integer getNotifyType() {
            return this.notifyType;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public String getWebHook() {
            return this.webHook;
        }

        public static final class Builder {
            private Integer endTime;
            private Integer notifyType;
            private Integer silenceTime;
            private Integer startTime;
            private String webHook;

            public Builder endTime(Integer endTime) {
                this.endTime = endTime;
                return this;
            }

            public Builder notifyType(Integer notifyType) {
                this.notifyType = notifyType;
                return this;
            }

            public Builder silenceTime(Integer silenceTime) {
                this.silenceTime = silenceTime;
                return this;
            }

            public Builder startTime(Integer startTime) {
                this.startTime = startTime;
                return this;
            }

            public Builder webHook(String webHook) {
                this.webHook = webHook;
                return this;
            }

            public AlertConfig build() {
                return new AlertConfig(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateHostAvailabilityRequest, Builder> {
        private AlertConfig alertConfig;
        private TaskOption taskOption;
        private List<AlertConfigEscalationList> alertConfigEscalationList;
        private List<AlertConfigTargetList> alertConfigTargetList;
        private Long groupId;
        private List<String> instanceList;
        private String taskName;
        private String taskScope;
        private String taskType;

        private Builder() {
        }

        private Builder(CreateHostAvailabilityRequest request) {
            super((Request)request);
            this.alertConfig = request.alertConfig;
            this.taskOption = request.taskOption;
            this.alertConfigEscalationList = request.alertConfigEscalationList;
            this.alertConfigTargetList = request.alertConfigTargetList;
            this.groupId = request.groupId;
            this.instanceList = request.instanceList;
            this.taskName = request.taskName;
            this.taskScope = request.taskScope;
            this.taskType = request.taskType;
        }

        public Builder alertConfig(AlertConfig alertConfig) {
            this.putQueryParameter("AlertConfig", (Object)alertConfig);
            this.alertConfig = alertConfig;
            return this;
        }

        public Builder taskOption(TaskOption taskOption) {
            this.putQueryParameter("TaskOption", (Object)taskOption);
            this.taskOption = taskOption;
            return this;
        }

        public Builder alertConfigEscalationList(List<AlertConfigEscalationList> alertConfigEscalationList) {
            this.putQueryParameter("AlertConfigEscalationList", alertConfigEscalationList);
            this.alertConfigEscalationList = alertConfigEscalationList;
            return this;
        }

        public Builder alertConfigTargetList(List<AlertConfigTargetList> alertConfigTargetList) {
            this.putQueryParameter("AlertConfigTargetList", alertConfigTargetList);
            this.alertConfigTargetList = alertConfigTargetList;
            return this;
        }

        public Builder groupId(Long groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder instanceList(List<String> instanceList) {
            this.putQueryParameter("InstanceList", instanceList);
            this.instanceList = instanceList;
            return this;
        }

        public Builder taskName(String taskName) {
            this.putQueryParameter("TaskName", taskName);
            this.taskName = taskName;
            return this;
        }

        public Builder taskScope(String taskScope) {
            this.putQueryParameter("TaskScope", taskScope);
            this.taskScope = taskScope;
            return this;
        }

        public Builder taskType(String taskType) {
            this.putQueryParameter("TaskType", taskType);
            this.taskType = taskType;
            return this;
        }

        public CreateHostAvailabilityRequest build() {
            return new CreateHostAvailabilityRequest(this);
        }
    }
}

