/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateGroupMonitoringAgentProcessRequest
extends Request {
    @Query
    @NameInMap(value="AlertConfig")
    @Validation(required=true)
    private List<AlertConfig> alertConfig;
    @Query
    @NameInMap(value="GroupId")
    @Validation(required=true)
    private String groupId;
    @Query
    @NameInMap(value="MatchExpress")
    private List<MatchExpress> matchExpress;
    @Query
    @NameInMap(value="MatchExpressFilterRelation")
    private String matchExpressFilterRelation;
    @Query
    @NameInMap(value="ProcessName")
    @Validation(required=true)
    private String processName;

    private CreateGroupMonitoringAgentProcessRequest(Builder builder) {
        super((Request.Builder)builder);
        this.alertConfig = builder.alertConfig;
        this.groupId = builder.groupId;
        this.matchExpress = builder.matchExpress;
        this.matchExpressFilterRelation = builder.matchExpressFilterRelation;
        this.processName = builder.processName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateGroupMonitoringAgentProcessRequest create() {
        return CreateGroupMonitoringAgentProcessRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<AlertConfig> getAlertConfig() {
        return this.alertConfig;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<MatchExpress> getMatchExpress() {
        return this.matchExpress;
    }

    public String getMatchExpressFilterRelation() {
        return this.matchExpressFilterRelation;
    }

    public String getProcessName() {
        return this.processName;
    }

    public static class MatchExpress
    extends TeaModel {
        @NameInMap(value="Function")
        private String function;
        @NameInMap(value="Name")
        private String name;
        @NameInMap(value="Value")
        private String value;

        private MatchExpress(Builder builder) {
            this.function = builder.function;
            this.name = builder.name;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MatchExpress create() {
            return MatchExpress.builder().build();
        }

        public String getFunction() {
            return this.function;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String function;
            private String name;
            private String value;

            public Builder function(String function) {
                this.function = function;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MatchExpress build() {
                return new MatchExpress(this);
            }
        }
    }

    public static class AlertConfig
    extends TeaModel {
        @NameInMap(value="ComparisonOperator")
        @Validation(required=true)
        private String comparisonOperator;
        @NameInMap(value="EffectiveInterval")
        private String effectiveInterval;
        @NameInMap(value="EscalationsLevel")
        @Validation(required=true)
        private String escalationsLevel;
        @NameInMap(value="NoEffectiveInterval")
        private String noEffectiveInterval;
        @NameInMap(value="SilenceTime")
        private String silenceTime;
        @NameInMap(value="Statistics")
        @Validation(required=true)
        private String statistics;
        @NameInMap(value="TargetList")
        private List<TargetList> targetList;
        @NameInMap(value="Threshold")
        @Validation(required=true)
        private String threshold;
        @NameInMap(value="Times")
        @Validation(required=true)
        private String times;
        @NameInMap(value="Webhook")
        private String webhook;

        private AlertConfig(Builder builder) {
            this.comparisonOperator = builder.comparisonOperator;
            this.effectiveInterval = builder.effectiveInterval;
            this.escalationsLevel = builder.escalationsLevel;
            this.noEffectiveInterval = builder.noEffectiveInterval;
            this.silenceTime = builder.silenceTime;
            this.statistics = builder.statistics;
            this.targetList = builder.targetList;
            this.threshold = builder.threshold;
            this.times = builder.times;
            this.webhook = builder.webhook;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static AlertConfig create() {
            return AlertConfig.builder().build();
        }

        public String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public String getEffectiveInterval() {
            return this.effectiveInterval;
        }

        public String getEscalationsLevel() {
            return this.escalationsLevel;
        }

        public String getNoEffectiveInterval() {
            return this.noEffectiveInterval;
        }

        public String getSilenceTime() {
            return this.silenceTime;
        }

        public String getStatistics() {
            return this.statistics;
        }

        public List<TargetList> getTargetList() {
            return this.targetList;
        }

        public String getThreshold() {
            return this.threshold;
        }

        public String getTimes() {
            return this.times;
        }

        public String getWebhook() {
            return this.webhook;
        }

        public static final class Builder {
            private String comparisonOperator;
            private String effectiveInterval;
            private String escalationsLevel;
            private String noEffectiveInterval;
            private String silenceTime;
            private String statistics;
            private List<TargetList> targetList;
            private String threshold;
            private String times;
            private String webhook;

            public Builder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            public Builder effectiveInterval(String effectiveInterval) {
                this.effectiveInterval = effectiveInterval;
                return this;
            }

            public Builder escalationsLevel(String escalationsLevel) {
                this.escalationsLevel = escalationsLevel;
                return this;
            }

            public Builder noEffectiveInterval(String noEffectiveInterval) {
                this.noEffectiveInterval = noEffectiveInterval;
                return this;
            }

            public Builder silenceTime(String silenceTime) {
                this.silenceTime = silenceTime;
                return this;
            }

            public Builder statistics(String statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder targetList(List<TargetList> targetList) {
                this.targetList = targetList;
                return this;
            }

            public Builder threshold(String threshold) {
                this.threshold = threshold;
                return this;
            }

            public Builder times(String times) {
                this.times = times;
                return this;
            }

            public Builder webhook(String webhook) {
                this.webhook = webhook;
                return this;
            }

            public AlertConfig build() {
                return new AlertConfig(this);
            }
        }
    }

    public static class TargetList
    extends TeaModel {
        @NameInMap(value="Arn")
        private String arn;
        @NameInMap(value="Id")
        private String id;
        @NameInMap(value="JsonParams")
        private String jsonParams;
        @NameInMap(value="Level")
        private String level;

        private TargetList(Builder builder) {
            this.arn = builder.arn;
            this.id = builder.id;
            this.jsonParams = builder.jsonParams;
            this.level = builder.level;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static TargetList create() {
            return TargetList.builder().build();
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public String getJsonParams() {
            return this.jsonParams;
        }

        public String getLevel() {
            return this.level;
        }

        public static final class Builder {
            private String arn;
            private String id;
            private String jsonParams;
            private String level;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder jsonParams(String jsonParams) {
                this.jsonParams = jsonParams;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public TargetList build() {
                return new TargetList(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateGroupMonitoringAgentProcessRequest, Builder> {
        private List<AlertConfig> alertConfig;
        private String groupId;
        private List<MatchExpress> matchExpress;
        private String matchExpressFilterRelation;
        private String processName;

        private Builder() {
        }

        private Builder(CreateGroupMonitoringAgentProcessRequest request) {
            super((Request)request);
            this.alertConfig = request.alertConfig;
            this.groupId = request.groupId;
            this.matchExpress = request.matchExpress;
            this.matchExpressFilterRelation = request.matchExpressFilterRelation;
            this.processName = request.processName;
        }

        public Builder alertConfig(List<AlertConfig> alertConfig) {
            this.putQueryParameter("AlertConfig", alertConfig);
            this.alertConfig = alertConfig;
            return this;
        }

        public Builder groupId(String groupId) {
            this.putQueryParameter("GroupId", groupId);
            this.groupId = groupId;
            return this;
        }

        public Builder matchExpress(List<MatchExpress> matchExpress) {
            this.putQueryParameter("MatchExpress", matchExpress);
            this.matchExpress = matchExpress;
            return this;
        }

        public Builder matchExpressFilterRelation(String matchExpressFilterRelation) {
            this.putQueryParameter("MatchExpressFilterRelation", matchExpressFilterRelation);
            this.matchExpressFilterRelation = matchExpressFilterRelation;
            return this;
        }

        public Builder processName(String processName) {
            this.putQueryParameter("ProcessName", processName);
            this.processName = processName;
            return this;
        }

        public CreateGroupMonitoringAgentProcessRequest build() {
            return new CreateGroupMonitoringAgentProcessRequest(this);
        }
    }
}

