/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateDynamicTagGroupRequest
extends Request {
    @Query
    @NameInMap(value="ContactGroupList")
    @Validation(required=true)
    private List<String> contactGroupList;
    @Query
    @NameInMap(value="EnableInstallAgent")
    private Boolean enableInstallAgent;
    @Query
    @NameInMap(value="EnableSubscribeEvent")
    private Boolean enableSubscribeEvent;
    @Query
    @NameInMap(value="MatchExpress")
    @Validation(required=true)
    private List<MatchExpress> matchExpress;
    @Query
    @NameInMap(value="MatchExpressFilterRelation")
    private String matchExpressFilterRelation;
    @Query
    @NameInMap(value="TagKey")
    @Validation(required=true)
    private String tagKey;
    @Query
    @NameInMap(value="TagRegionId")
    private String tagRegionId;
    @Query
    @NameInMap(value="TemplateIdList")
    private List<String> templateIdList;

    private CreateDynamicTagGroupRequest(Builder builder) {
        super((Request.Builder)builder);
        this.contactGroupList = builder.contactGroupList;
        this.enableInstallAgent = builder.enableInstallAgent;
        this.enableSubscribeEvent = builder.enableSubscribeEvent;
        this.matchExpress = builder.matchExpress;
        this.matchExpressFilterRelation = builder.matchExpressFilterRelation;
        this.tagKey = builder.tagKey;
        this.tagRegionId = builder.tagRegionId;
        this.templateIdList = builder.templateIdList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateDynamicTagGroupRequest create() {
        return CreateDynamicTagGroupRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getContactGroupList() {
        return this.contactGroupList;
    }

    public Boolean getEnableInstallAgent() {
        return this.enableInstallAgent;
    }

    public Boolean getEnableSubscribeEvent() {
        return this.enableSubscribeEvent;
    }

    public List<MatchExpress> getMatchExpress() {
        return this.matchExpress;
    }

    public String getMatchExpressFilterRelation() {
        return this.matchExpressFilterRelation;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public String getTagRegionId() {
        return this.tagRegionId;
    }

    public List<String> getTemplateIdList() {
        return this.templateIdList;
    }

    public static class MatchExpress
    extends TeaModel {
        @NameInMap(value="TagName")
        private String tagName;
        @NameInMap(value="TagValue")
        private String tagValue;
        @NameInMap(value="TagValueMatchFunction")
        private String tagValueMatchFunction;

        private MatchExpress(Builder builder) {
            this.tagName = builder.tagName;
            this.tagValue = builder.tagValue;
            this.tagValueMatchFunction = builder.tagValueMatchFunction;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static MatchExpress create() {
            return MatchExpress.builder().build();
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public String getTagValueMatchFunction() {
            return this.tagValueMatchFunction;
        }

        public static final class Builder {
            private String tagName;
            private String tagValue;
            private String tagValueMatchFunction;

            public Builder tagName(String tagName) {
                this.tagName = tagName;
                return this;
            }

            public Builder tagValue(String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            public Builder tagValueMatchFunction(String tagValueMatchFunction) {
                this.tagValueMatchFunction = tagValueMatchFunction;
                return this;
            }

            public MatchExpress build() {
                return new MatchExpress(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateDynamicTagGroupRequest, Builder> {
        private List<String> contactGroupList;
        private Boolean enableInstallAgent;
        private Boolean enableSubscribeEvent;
        private List<MatchExpress> matchExpress;
        private String matchExpressFilterRelation;
        private String tagKey;
        private String tagRegionId;
        private List<String> templateIdList;

        private Builder() {
        }

        private Builder(CreateDynamicTagGroupRequest request) {
            super((Request)request);
            this.contactGroupList = request.contactGroupList;
            this.enableInstallAgent = request.enableInstallAgent;
            this.enableSubscribeEvent = request.enableSubscribeEvent;
            this.matchExpress = request.matchExpress;
            this.matchExpressFilterRelation = request.matchExpressFilterRelation;
            this.tagKey = request.tagKey;
            this.tagRegionId = request.tagRegionId;
            this.templateIdList = request.templateIdList;
        }

        public Builder contactGroupList(List<String> contactGroupList) {
            this.putQueryParameter("ContactGroupList", contactGroupList);
            this.contactGroupList = contactGroupList;
            return this;
        }

        public Builder enableInstallAgent(Boolean enableInstallAgent) {
            this.putQueryParameter("EnableInstallAgent", enableInstallAgent);
            this.enableInstallAgent = enableInstallAgent;
            return this;
        }

        public Builder enableSubscribeEvent(Boolean enableSubscribeEvent) {
            this.putQueryParameter("EnableSubscribeEvent", enableSubscribeEvent);
            this.enableSubscribeEvent = enableSubscribeEvent;
            return this;
        }

        public Builder matchExpress(List<MatchExpress> matchExpress) {
            this.putQueryParameter("MatchExpress", matchExpress);
            this.matchExpress = matchExpress;
            return this;
        }

        public Builder matchExpressFilterRelation(String matchExpressFilterRelation) {
            this.putQueryParameter("MatchExpressFilterRelation", matchExpressFilterRelation);
            this.matchExpressFilterRelation = matchExpressFilterRelation;
            return this;
        }

        public Builder tagKey(String tagKey) {
            this.putQueryParameter("TagKey", tagKey);
            this.tagKey = tagKey;
            return this;
        }

        public Builder tagRegionId(String tagRegionId) {
            this.putQueryParameter("TagRegionId", tagRegionId);
            this.tagRegionId = tagRegionId;
            return this;
        }

        public Builder templateIdList(List<String> templateIdList) {
            this.putQueryParameter("TemplateIdList", templateIdList);
            this.templateIdList = templateIdList;
            return this;
        }

        public CreateDynamicTagGroupRequest build() {
            return new CreateDynamicTagGroupRequest(this);
        }
    }
}

