/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class BatchExportRequest
extends Request {
    @Body
    @NameInMap(value="Cursor")
    @Validation(required=true)
    private String cursor;
    @Body
    @NameInMap(value="Length")
    @Validation(required=true)
    private Integer length;
    @Body
    @NameInMap(value="Measurements")
    private List<String> measurements;
    @Body
    @NameInMap(value="Metric")
    @Validation(required=true)
    private String metric;
    @Body
    @NameInMap(value="Namespace")
    @Validation(required=true)
    private String namespace;

    private BatchExportRequest(Builder builder) {
        super((Request.Builder)builder);
        this.cursor = builder.cursor;
        this.length = builder.length;
        this.measurements = builder.measurements;
        this.metric = builder.metric;
        this.namespace = builder.namespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BatchExportRequest create() {
        return BatchExportRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getCursor() {
        return this.cursor;
    }

    public Integer getLength() {
        return this.length;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static final class Builder
    extends Request.Builder<BatchExportRequest, Builder> {
        private String cursor;
        private Integer length;
        private List<String> measurements;
        private String metric;
        private String namespace;

        private Builder() {
        }

        private Builder(BatchExportRequest request) {
            super((Request)request);
            this.cursor = request.cursor;
            this.length = request.length;
            this.measurements = request.measurements;
            this.metric = request.metric;
            this.namespace = request.namespace;
        }

        public Builder cursor(String cursor) {
            this.putBodyParameter("Cursor", cursor);
            this.cursor = cursor;
            return this;
        }

        public Builder length(Integer length) {
            this.putBodyParameter("Length", length);
            this.length = length;
            return this;
        }

        public Builder measurements(List<String> measurements) {
            String measurementsShrink = this.shrink(measurements, "Measurements", "json");
            this.putBodyParameter("Measurements", measurementsShrink);
            this.measurements = measurements;
            return this;
        }

        public Builder metric(String metric) {
            this.putBodyParameter("Metric", metric);
            this.metric = metric;
            return this;
        }

        public Builder namespace(String namespace) {
            this.putBodyParameter("Namespace", namespace);
            this.namespace = namespace;
            return this;
        }

        public BatchExportRequest build() {
            return new BatchExportRequest(this);
        }
    }
}

