/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.cms20190101.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class AddTagsRequest
extends Request {
    @Query
    @NameInMap(value="GroupIds")
    @Validation(required=true)
    private List<String> groupIds;
    @Query
    @NameInMap(value="Tag")
    @Validation(required=true)
    private List<Tag> tag;

    private AddTagsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.groupIds = builder.groupIds;
        this.tag = builder.tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddTagsRequest create() {
        return AddTagsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        @Validation(required=true)
        private String key;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<AddTagsRequest, Builder> {
        private List<String> groupIds;
        private List<Tag> tag;

        private Builder() {
        }

        private Builder(AddTagsRequest request) {
            super((Request)request);
            this.groupIds = request.groupIds;
            this.tag = request.tag;
        }

        public Builder groupIds(List<String> groupIds) {
            this.putQueryParameter("GroupIds", groupIds);
            this.groupIds = groupIds;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public AddTagsRequest build() {
            return new AddTagsRequest(this);
        }
    }
}

