/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.runner;

import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.common.DelegateArkContainer;
import com.alipay.sofa.ark.support.runner.JUnitExecutionListener;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

public class ArkBootRunner
extends Runner
implements Filterable,
Sortable {
    private static final String SPRING_RUNNER = "org.springframework.test.context.junit4.SpringRunner";
    private Runner runner;

    public ArkBootRunner(Class<?> klazz) {
        if (!DelegateArkContainer.isStarted()) {
            DelegateArkContainer.launch(klazz);
        }
        Class springRunnerClass = DelegateArkContainer.loadClass((String)SPRING_RUNNER);
        Class testClass = DelegateArkContainer.loadClass((String)klazz.getName());
        try {
            this.runner = (Runner)springRunnerClass.getConstructor(Class.class).newInstance(testClass);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void run(RunNotifier notifier) {
        ClassLoader oldClassLoader = ClassLoaderUtils.pushContextClassLoader((ClassLoader)DelegateArkContainer.getTestClassLoader());
        try {
            notifier.addListener(JUnitExecutionListener.getRunListener());
            this.runner.run(notifier);
        }
        finally {
            ClassLoaderUtils.popContextClassLoader((ClassLoader)oldClassLoader);
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.runner).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.runner).sort(sorter);
    }
}

