/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot;

import com.alipay.sofa.ark.springboot.condition.ConditionalOnArkEnabled;
import com.alipay.sofa.ark.springboot.web.ArkTomcatServletWebServerFactory;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnArkEnabled
@ConditionalOnClass(value={ServletWebServerFactoryAutoConfiguration.class, TomcatProtocolHandlerCustomizer.class})
@AutoConfigureBefore(value={ServletWebServerFactoryAutoConfiguration.class})
public class ArkServletAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Tomcat.class, UpgradeProtocol.class, ServletWebServerFactory.class}, name={"com.alipay.sofa.ark.web.embed.tomcat.ArkTomcatEmbeddedWebappClassLoader"})
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedArkTomcat {
        @Bean
        @ConditionalOnMissingBean(value={ArkTomcatServletWebServerFactory.class})
        public TomcatServletWebServerFactory tomcatServletWebServerFactory(ObjectProvider<TomcatConnectorCustomizer> connectorCustomizers, ObjectProvider<TomcatContextCustomizer> contextCustomizers, ObjectProvider<TomcatProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
            ArkTomcatServletWebServerFactory factory = new ArkTomcatServletWebServerFactory();
            factory.getTomcatConnectorCustomizers().addAll(connectorCustomizers.orderedStream().collect(Collectors.toList()));
            factory.getTomcatContextCustomizers().addAll(contextCustomizers.orderedStream().collect(Collectors.toList()));
            factory.getTomcatProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().collect(Collectors.toList()));
            return factory;
        }
    }
}

