/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.condition;

import com.alipay.sofa.ark.api.ArkConfigs;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=-2147483548)
public class OnArkEnabled
extends SpringBootCondition {
    private static final String ARK_TEST_CLASSLOADER_NAME = "com.alipay.sofa.ark.container.test.TestClassLoader";
    private static final String ARK_BIZ_CLASSLOADER_NAME = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static final String ARK_PLUGIN_CLASSLOADER_NAME = "com.alipay.sofa.ark.container.service.classloader.PluginClassLoader";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String currentClassLoader = ((Object)((Object)this)).getClass().getClassLoader().getClass().getName();
        if (ARK_TEST_CLASSLOADER_NAME.equals(currentClassLoader) || ARK_BIZ_CLASSLOADER_NAME.equals(currentClassLoader) || ARK_PLUGIN_CLASSLOADER_NAME.equals(currentClassLoader)) {
            return new ConditionOutcome(true, "SOFAArk has started.");
        }
        if (ArkConfigs.isEmbedEnable()) {
            return new ConditionOutcome(true, "Embed SOFAArk has started.");
        }
        return new ConditionOutcome(false, "SOFAArk has not started.");
    }
}

