/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.component.impl.ReferenceImpl;
import com.alipay.sofa.runtime.service.component.impl.ServiceImpl;
import com.alipay.sofa.runtime.service.helper.ReferenceRegisterHelper;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ServiceAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private SofaRuntimeContext sofaRuntimeContext;
    private BindingAdapterFactory bindingAdapterFactory;
    private BindingConverterFactory bindingConverterFactory;
    private ApplicationContext applicationContext;

    public ServiceAnnotationBeanPostProcessor(BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory) {
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.bindingConverterFactory = bindingConverterFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.processSofaReference(bean);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processSofaService(bean, beanName);
        return bean;
    }

    private void processSofaService(Object bean, String beanName) {
        Class<?> beanClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        SofaService sofaServiceAnnotation = beanClass.getAnnotation(SofaService.class);
        if (sofaServiceAnnotation == null) {
            return;
        }
        Class<?> interfaceType = sofaServiceAnnotation.interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            Class<?>[] interfaces = beanClass.getInterfaces();
            if (interfaces == null || interfaces.length == 0) {
                interfaceType = beanClass;
            } else if (interfaces.length == 1) {
                interfaceType = interfaces[0];
            } else {
                throw new ServiceRuntimeException("Bean " + beanName + " has more than one interface.");
            }
        }
        DefaultImplementation implementation = new DefaultImplementation(bean);
        ServiceImpl service = new ServiceImpl(sofaServiceAnnotation.uniqueId(), interfaceType, InterfaceMode.annotation, bean);
        for (SofaServiceBinding sofaServiceBinding : sofaServiceAnnotation.bindings()) {
            this.handleSofaServiceBinding(service, sofaServiceAnnotation, sofaServiceBinding);
        }
        ServiceComponent componentInfo = new ServiceComponent(implementation, service, this.bindingAdapterFactory, this.getSofaRuntimeContext());
        this.getSofaRuntimeContext().getComponentManager().register(componentInfo);
    }

    private void processSofaReference(final Object bean) {
        Class<?> beanClass = bean.getClass();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                SofaReference sofaReferenceAnnotation = field.getAnnotation(SofaReference.class);
                if (sofaReferenceAnnotation == null) {
                    return;
                }
                Class<?> interfaceType = sofaReferenceAnnotation.interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = field.getType();
                }
                Object proxy = ServiceAnnotationBeanPostProcessor.this.createReferenceProxy(sofaReferenceAnnotation, interfaceType);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, (Object)proxy);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(SofaReference.class);
            }
        });
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?>[] parameterTypes = method.getParameterTypes();
                Assert.isTrue((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"method should have one and only one parameter.");
                SofaReference sofaReferenceAnnotation = method.getAnnotation(SofaReference.class);
                if (sofaReferenceAnnotation == null) {
                    return;
                }
                Class<?> interfaceType = sofaReferenceAnnotation.interfaceType();
                if (interfaceType.equals(Void.TYPE)) {
                    interfaceType = parameterTypes[0];
                }
                Object proxy = ServiceAnnotationBeanPostProcessor.this.createReferenceProxy(sofaReferenceAnnotation, interfaceType);
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{proxy});
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return method.isAnnotationPresent(SofaReference.class);
            }
        });
    }

    private void handleSofaServiceBinding(Service service, SofaService sofaServiceAnnotation, SofaServiceBinding sofaServiceBinding) {
        if (JvmBinding.JVM_BINDING_TYPE.getType().equals(sofaServiceBinding.bindingType())) {
            service.addBinding(new JvmBinding());
        } else {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaServiceBinding.bindingType()));
            if (bindingConverter == null) {
                throw new ServiceRuntimeException("Can not found binding converter for binding type " + sofaServiceBinding.bindingType());
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(false);
            bindingConverterContext.setApplicationContext(this.applicationContext);
            bindingConverterContext.setAppName(this.getSofaRuntimeContext().getAppName());
            bindingConverterContext.setAppClassLoader(this.getSofaRuntimeContext().getAppClassLoader());
            Object binding = bindingConverter.convert(sofaServiceAnnotation, sofaServiceBinding, bindingConverterContext);
            service.addBinding(binding);
        }
    }

    private Object createReferenceProxy(SofaReference sofaReferenceAnnotation, Class<?> interfaceType) {
        ReferenceImpl reference = new ReferenceImpl(sofaReferenceAnnotation.uniqueId(), interfaceType, InterfaceMode.annotation, sofaReferenceAnnotation.jvmFirst());
        if (JvmBinding.JVM_BINDING_TYPE.getType().equals(sofaReferenceAnnotation.binding().bindingType())) {
            reference.addBinding(new JvmBinding());
        } else {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaReferenceAnnotation.binding().bindingType()));
            if (bindingConverter == null) {
                throw new ServiceRuntimeException("Can not found binding converter for binding type " + sofaReferenceAnnotation.binding().bindingType());
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(true);
            bindingConverterContext.setApplicationContext(this.applicationContext);
            bindingConverterContext.setAppName(this.getSofaRuntimeContext().getAppName());
            bindingConverterContext.setAppClassLoader(this.getSofaRuntimeContext().getAppClassLoader());
            Object binding = bindingConverter.convert(sofaReferenceAnnotation, sofaReferenceAnnotation.binding(), bindingConverterContext);
            reference.addBinding(binding);
        }
        return ReferenceRegisterHelper.registerReference(reference, this.bindingAdapterFactory, this.getSofaRuntimeContext());
    }

    private SofaRuntimeContext getSofaRuntimeContext() {
        if (this.sofaRuntimeContext == null) {
            this.sofaRuntimeContext = (SofaRuntimeContext)this.applicationContext.getBean("sofaRuntimeContext", SofaRuntimeContext.class);
        }
        return this.sofaRuntimeContext;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

