/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver.handler;

import com.alipay.remoting.Connection;
import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.NotifyDataSyncRequest;
import com.alipay.sofa.registry.common.model.dataserver.SyncDataRequest;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.bolt.BoltChannel;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerConfig;
import com.alipay.sofa.registry.server.data.cache.DatumCache;
import com.alipay.sofa.registry.server.data.change.event.DataChangeEventCenter;
import com.alipay.sofa.registry.server.data.executor.ExecutorFactory;
import com.alipay.sofa.registry.server.data.remoting.dataserver.GetSyncDataHandler;
import com.alipay.sofa.registry.server.data.remoting.dataserver.SyncDataCallback;
import com.alipay.sofa.registry.server.data.remoting.handler.AbstractClientHandler;
import com.alipay.sofa.registry.server.data.util.ThreadPoolExecutorDataServer;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import com.alipay.sofa.registry.util.ParaCheckUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyDataSyncHandler
extends AbstractClientHandler<NotifyDataSyncRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyDataSyncHandler.class);
    @Autowired
    private DataServerConfig dataServerBootstrapConfig;
    @Autowired
    private GetSyncDataHandler getSyncDataHandler;
    @Autowired
    private DataChangeEventCenter dataChangeEventCenter;
    private Executor executor = ExecutorFactory.newFixedThreadPool(10, NotifyDataSyncHandler.class.getSimpleName());
    private ThreadPoolExecutor notifyExecutor;

    @Override
    public void checkParam(NotifyDataSyncRequest request) throws RuntimeException {
        ParaCheckUtil.checkNotBlank((String)request.getDataInfoId(), (String)"request.dataInfoId");
    }

    @Override
    public Object doHandle(Channel channel, NotifyDataSyncRequest request) {
        Connection connection = ((BoltChannel)channel).getConnection();
        this.executor.execute(() -> {
            String dataInfoId = request.getDataInfoId();
            String dataCenter = request.getDataCenter();
            Datum datum = DatumCache.get(dataCenter, dataInfoId);
            Long version = datum == null ? null : Long.valueOf(datum.getVersion());
            Long requestVersion = request.getVersion();
            if (version == null || requestVersion == 0L || version < requestVersion) {
                LOGGER.info("[NotifyDataSyncProcessor] begin get sync data, currentVersion={},request={}", (Object)version, (Object)request);
                this.getSyncDataHandler.syncData(new SyncDataCallback(this.getSyncDataHandler, connection, new SyncDataRequest(dataInfoId, dataCenter, version, request.getDataSourceType()), this.dataChangeEventCenter));
            } else {
                LOGGER.info("[NotifyDataSyncHandler] not need to sync data, version={}", (Object)version);
            }
        });
        return CommonResponse.buildSuccessResponse();
    }

    public CommonResponse buildFailedResponse(String msg) {
        return CommonResponse.buildFailedResponse((String)msg);
    }

    @Override
    public Class interest() {
        return NotifyDataSyncRequest.class;
    }

    public Executor getExecutor() {
        if (this.notifyExecutor == null) {
            this.notifyExecutor = new ThreadPoolExecutorDataServer("NotifyDataSyncProcessorExecutor", this.dataServerBootstrapConfig.getNotifyDataSyncExecutorMinPoolSize(), this.dataServerBootstrapConfig.getNotifyDataSyncExecutorMaxPoolSize(), this.dataServerBootstrapConfig.getNotifyDataSyncExecutorKeepAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.dataServerBootstrapConfig.getNotifyDataSyncExecutorQueueSize()), (ThreadFactory)new NamedThreadFactory("DataServer-NotifyDataSyncProcessor-executor", true));
        }
        return this.notifyExecutor;
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    protected Node.NodeType getConnectNodeType() {
        return Node.NodeType.DATA;
    }
}

