/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.datasync.sync;

import com.alipay.sofa.registry.server.data.datasync.AcceptorStore;
import com.alipay.sofa.registry.task.scheduler.TimedSupervisorTask;
import com.alipay.sofa.registry.util.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public class Scheduler {
    public final ExecutorService versionCheckExecutor;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new NamedThreadFactory("SyncDataScheduler"));
    private final ThreadPoolExecutor expireCheckExecutor = new ThreadPoolExecutor(1, 3, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SyncDataScheduler-expireChangeCheck"));
    @Autowired
    private AcceptorStore localAcceptorStore;

    public Scheduler() {
        this.versionCheckExecutor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("SyncDataScheduler-versionChangeCheck"));
    }

    public void startScheduler() {
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("FetchDataLocal", this.scheduler, this.expireCheckExecutor, 3, TimeUnit.SECONDS, 10, () -> this.localAcceptorStore.checkAcceptorsChangAndExpired()), 30L, TimeUnit.SECONDS);
        this.versionCheckExecutor.execute(() -> this.localAcceptorStore.changeDataCheck());
    }

    public void stopScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        if (this.versionCheckExecutor != null && !this.versionCheckExecutor.isShutdown()) {
            this.versionCheckExecutor.shutdown();
        }
    }
}

