/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.change;

import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.server.data.change.DataChangeTypeEnum;
import com.alipay.sofa.registry.server.data.change.DataSourceTypeEnum;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class ChangeData
implements Delayed {
    private Datum datum;
    private Long gmtCreate;
    private long timeout;
    private DataSourceTypeEnum sourceType;
    private DataChangeTypeEnum changeType;

    public ChangeData(Datum datum, long timeout, DataSourceTypeEnum sourceType, DataChangeTypeEnum changeType) {
        this.datum = datum;
        this.gmtCreate = System.currentTimeMillis();
        this.timeout = timeout;
        this.sourceType = sourceType;
        this.changeType = changeType;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public void setDatum(Datum datum) {
        this.datum = datum;
    }

    public DataSourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public DataChangeTypeEnum getChangeType() {
        return this.changeType;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.gmtCreate + this.timeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof ChangeData) {
            ChangeData other = (ChangeData)o;
            if (this.gmtCreate < other.gmtCreate) {
                return -1;
            }
            if (this.gmtCreate > other.gmtCreate) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

