/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayResponse;
import com.alipay.api.internal.parser.json.ObjectJsonParser;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.json.JSONReader;
import com.alipay.api.internal.util.json.JSONValidatingReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AlipayUtils {
    private static String localIp;
    private static String RADIX_62_CHARS;

    private AlipayUtils() {
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = AlipayUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<?, ?> parseJson(String body) {
        JSONValidatingReader jr = new JSONValidatingReader();
        Object obj = ((JSONReader)jr).read(body);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static <T extends AlipayResponse> T parseResponse(String json, Class<T> clazz) throws AlipayApiException {
        ObjectJsonParser<T> parser = new ObjectJsonParser<T>(clazz);
        return parser.parse(json);
    }

    public static String getLocalNetWorkIp() {
        if (localIp != null) {
            return localIp;
        }
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual()) continue;
                Enumeration<InetAddress> addresss = ni.getInetAddresses();
                while (addresss.hasMoreElements()) {
                    InetAddress address = addresss.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    ip = address;
                    break;
                }
                if (ip == null) continue;
                break;
            }
            localIp = ip != null ? ip.getHostAddress() : "127.0.0.1";
        }
        catch (Exception e) {
            localIp = "127.0.0.1";
        }
        return localIp;
    }

    public static String toRadix62Str(long num, int length) {
        StringBuilder sb = new StringBuilder();
        int remainder = 0;
        while (num >= 62L) {
            remainder = Long.valueOf(num % 62L).intValue();
            sb.append(RADIX_62_CHARS.charAt(remainder));
            num /= 62L;
        }
        sb.append(RADIX_62_CHARS.charAt(Long.valueOf(num).intValue()));
        String value = sb.reverse().toString();
        return StringUtils.leftPad(value, length, '0');
    }

    public static long fromRadix62Str(String str) {
        str = str.replace("^0*", "");
        long num = 0L;
        int index = 0;
        for (int i = 0; i < str.length(); ++i) {
            index = RADIX_62_CHARS.indexOf(str.charAt(i));
            num += (long)((double)index * Math.pow(62.0, str.length() - i - 1));
        }
        return num;
    }

    static {
        RADIX_62_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    }
}

