/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.attribute.MultiAttribute;
import com.alipay.service.schema.model.attribute.SingleAttribute;
import com.alipay.service.schema.model.enums.AttrTypeEnum;
import com.alipay.service.schema.model.enums.AttrValueTypeEnum;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.model.option.Option;
import com.alipay.service.schema.model.rule.AttributeRule;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public abstract class Attribute {
    private String id;
    private String name;
    private AttrTypeEnum type;
    private AttrValueTypeEnum valueType;
    private List<AttributeRule> rules = new ArrayList<AttributeRule>();
    private List<Option> options = new ArrayList<Option>();

    public abstract Element toElement() throws ServiceSchemaException;

    public void addRule(AttributeRule rule) {
        this.rules.add(rule);
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    protected void appendRulesElement(Element parent, List<AttributeRule> rules, String attributeId) throws ServiceSchemaException {
        if (rules == null || rules.size() <= 0) {
            return;
        }
        Element rulesElm = XmlUtils.appendElement(parent, "rules");
        for (AttributeRule rule : rules) {
            Element element = rule.toElement(attributeId);
            rulesElm.add(element);
        }
    }

    protected void appendOptionsElement(Element parent, List<Option> options, String attributeId) throws ServiceSchemaException {
        if (options == null || options.size() <= 0) {
            return;
        }
        Element optionsElm = XmlUtils.appendElement(parent, "options");
        for (Option option : options) {
            Element optionElm = option.toElement(attributeId);
            optionsElm.add(optionElm);
        }
    }

    protected void appendAttributeValues(Attribute attribute, Element parent) throws ServiceSchemaException {
        if (attribute.getType() == AttrTypeEnum.SINGLE) {
            this.appendSingleAttributValue(parent, attribute);
        } else if (attribute.getType() == AttrTypeEnum.MULTI) {
            this.appendMultiAttributValue(parent, attribute);
        } else {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_TYPE_ERROR, attribute.getId());
        }
    }

    protected void appendSingleAttributValue(Element parent, Attribute attribute) {
        Element valueElm = XmlUtils.appendElement(parent, "value");
        SingleAttribute singleAttribute = (SingleAttribute)attribute;
        if (!StringUtil.isEmpty(singleAttribute.getValue())) {
            valueElm.setText(singleAttribute.getValue());
        }
    }

    protected void appendMultiAttributValue(Element parent, Attribute attribute) {
        Element valuesElm = XmlUtils.appendElement(parent, "values");
        MultiAttribute multiAttribute = (MultiAttribute)attribute;
        for (String value : multiAttribute.getValues()) {
            Element valueElm = XmlUtils.appendElement(valuesElm, "value");
            if (StringUtil.isEmpty(value)) continue;
            valueElm.setText(value);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AttrTypeEnum getType() {
        return this.type;
    }

    public void setType(AttrTypeEnum type) {
        this.type = type;
    }

    public AttrValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(AttrValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public List<AttributeRule> getRules() {
        return this.rules;
    }

    public void setRules(List<AttributeRule> rules) {
        this.rules = rules;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }
}

