/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.model.Resource;
import com.alibaba.fescar.rm.DefaultResourceManager;
import com.alibaba.fescar.rm.datasource.AbstractDataSourceProxy;
import com.alibaba.fescar.rm.datasource.ConnectionProxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private String resourceGroupId;
    private static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT";
    private String jdbcUrl;
    private String dbType;
    private boolean managed = false;

    public DataSourceProxy(DataSource targetDataSource) {
        this(targetDataSource, DEFAULT_RESOURCE_GROUP_ID);
    }

    public DataSourceProxy(DataSource targetDataSource, String resourceGroupId) {
        super(targetDataSource);
        this.init(targetDataSource, resourceGroupId);
    }

    private void init(DataSource dataSource, String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType((String)this.jdbcUrl, null);
        }
        catch (SQLException e) {
            throw new IllegalStateException(String.format("can not init dataSource :%s", e.getSQLState()));
        }
    }

    private void assertManaged() {
        if (!this.managed) {
            DefaultResourceManager.get().registerResource((Resource)this);
            this.managed = true;
        }
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        this.assertManaged();
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        this.assertManaged();
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceId() {
        return this.jdbcUrl;
    }

    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

