/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.codegen;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.internal.codegen.ClassWriter;
import com.alibaba.fastjson2.internal.codegen.MethodWriter;
import com.alibaba.fastjson2.internal.codegen.Opcodes;
import java.util.ArrayList;
import java.util.List;

public class Block {
    protected final List<Statement> statements = new ArrayList<Statement>();

    public void invoke(String method, Opcodes.Op ... args) {
        this.statements.add(new StatementOp(Opcodes.invoke(method, args)));
    }

    public void invoke(Opcodes.Op owner, String method, Opcodes.Op ... args) {
        this.statements.add(new StatementOp(Opcodes.invoke(owner, method, args)));
    }

    public void putField(String fieldName, Opcodes.Op value) {
        this.putField(Opcodes.THIS, fieldName, value);
    }

    public void putField(Opcodes.Op owner, String fieldName, Opcodes.Op value) {
        this.statements.add(new StatementOp(Opcodes.putField(owner, fieldName, value)));
    }

    public void ret(Opcodes.Op value) {
        this.statements.add(new StatementRet(value));
    }

    public void continueStmt() {
        this.statements.add(new StatementContinue(null));
    }

    public void continueStmt(String label) {
        this.statements.add(new StatementContinue(label));
    }

    public void breakStmt() {
        this.statements.add(new StatementBreak(null));
    }

    public void breakStmt(String label) {
        this.statements.add(new StatementBreak(label));
    }

    public IfStmt ifStmt(Opcodes.Op testValue) {
        IfStmt stmt = new IfStmt(testValue);
        this.statements.add(stmt);
        return stmt;
    }

    public IfStmt ifNull(Opcodes.Op testValue) {
        IfStmt stmt = new IfStmt(Opcodes.eq(testValue, Opcodes.ldc(null)));
        this.statements.add(stmt);
        return stmt;
    }

    public IfStmt ifNotNull(Opcodes.Op testValue) {
        IfStmt stmt = new IfStmt(Opcodes.ne(testValue, Opcodes.ldc(null)));
        this.statements.add(stmt);
        return stmt;
    }

    public void newLine() {
        this.statements.add(new Empty());
    }

    public void label(String label) {
        this.statements.add(new Label(label));
    }

    public ForStmt forStmt(Class initType, Opcodes.Op init, Opcodes.Op condition, Opcodes.Op increment) {
        ForStmt stmt = new ForStmt(initType, init, condition, increment);
        this.statements.add(stmt);
        return stmt;
    }

    public WhileStmt whileStmtStmt(Opcodes.Op condition) {
        WhileStmt stmt = new WhileStmt(condition);
        this.statements.add(stmt);
        return stmt;
    }

    public SwitchStmt switchStmt(Opcodes.Op op, int[] hashCodes) {
        SwitchStmt stmt = new SwitchStmt(op, hashCodes);
        this.statements.add(stmt);
        return stmt;
    }

    public Statement stmt(Opcodes.Op op) {
        StatementOp stmt = new StatementOp(op);
        this.statements.add(stmt);
        return stmt;
    }

    public Statement declare(Class type, Opcodes.OpName name) {
        DeclareStmt stmt = new DeclareStmt(ClassWriter.getTypeName(type), name, null);
        this.statements.add(stmt);
        return stmt;
    }

    public Statement declare(String type, Opcodes.OpName name) {
        DeclareStmt stmt = new DeclareStmt(type, name, null);
        this.statements.add(stmt);
        return stmt;
    }

    public Statement declare(Class type, Opcodes.OpName name, Opcodes.Op initValue) {
        DeclareStmt stmt = new DeclareStmt(ClassWriter.getTypeName(type), name, initValue);
        this.statements.add(stmt);
        return stmt;
    }

    public Statement declare(Class type, Opcodes.OpName name, Object initValue) {
        DeclareStmt stmt = new DeclareStmt(ClassWriter.getTypeName(type), name, initValue == null ? null : Opcodes.ldc(initValue));
        this.statements.add(stmt);
        return stmt;
    }

    public Statement declare(String type, Opcodes.OpName name, Opcodes.Op initValue) {
        DeclareStmt stmt = new DeclareStmt(type, name, initValue == null ? null : Opcodes.ldc(initValue));
        this.statements.add(stmt);
        return stmt;
    }

    public static class StatementOp
    implements Statement {
        public final Opcodes.Op op;

        StatementOp(Opcodes.Op op) {
            this.op = op;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            this.op.toString(mw, buf, indent);
            buf.append(';');
        }
    }

    public static class StatementRet
    implements Statement {
        public final Opcodes.Op op;

        public StatementRet(Opcodes.Op op) {
            this.op = op;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("return");
            if (this.op != null) {
                buf.append(' ');
                this.op.toString(mw, buf, indent);
            }
            buf.append(';');
        }
    }

    public static class StatementContinue
    implements Statement {
        public final String label;

        public StatementContinue(String label) {
            this.label = label;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("continue");
            if (this.label != null) {
                buf.append(' ');
                buf.append(this.label);
            }
            buf.append(';');
        }
    }

    public static class StatementBreak
    implements Statement {
        public final String label;

        public StatementBreak(String label) {
            this.label = label;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("break");
            if (this.label != null) {
                buf.append(' ');
                buf.append(this.label);
            }
            buf.append(';');
        }
    }

    public static class IfStmt
    extends Block
    implements Statement {
        final Opcodes.Op condition;
        Block elseStmt;

        public IfStmt(Opcodes.Op testValue) {
            this.condition = testValue;
        }

        public Block elseStmt() {
            if (this.elseStmt == null) {
                this.elseStmt = new Block();
            }
            return this.elseStmt;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            Statement stmt;
            int i;
            mw.ident(buf, indent);
            buf.append("if (");
            this.condition.toString(mw, buf, indent);
            buf.append(") {").append('\n');
            for (i = 0; i < this.statements.size(); ++i) {
                if (i != 0) {
                    buf.append('\n');
                }
                stmt = (Statement)this.statements.get(i);
                stmt.toString(mw, buf, indent + 1);
            }
            buf.append('\n');
            mw.ident(buf, indent);
            buf.append("}");
            if (this.elseStmt != null) {
                buf.append(" else {\n");
                for (i = 0; i < this.elseStmt.statements.size(); ++i) {
                    if (i != 0) {
                        buf.append('\n');
                    }
                    stmt = this.elseStmt.statements.get(i);
                    stmt.toString(mw, buf, indent + 1);
                }
                buf.append('\n');
                mw.ident(buf, indent);
                buf.append("}");
            }
        }
    }

    public static class Empty
    implements Statement {
        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
        }
    }

    public static class Label
    implements Statement {
        final String label;

        public Label(String label) {
            this.label = label;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append(this.label).append(':');
        }
    }

    public static class ForStmt
    extends Block
    implements Statement {
        final Class initType;
        final Opcodes.Op init;
        final Opcodes.Op condition;
        final Opcodes.Op increment;

        public ForStmt(Class initType, Opcodes.Op init, Opcodes.Op condition, Opcodes.Op increment) {
            this.initType = initType;
            this.init = init;
            this.condition = condition;
            this.increment = increment;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("for (");
            if (this.initType != null) {
                buf.append(this.initType.getSimpleName()).append(' ');
            }
            if (this.init != null) {
                this.init.toString(mw, buf, indent);
            }
            buf.append(';');
            if (this.condition != null) {
                buf.append(' ');
                this.condition.toString(mw, buf, indent);
            }
            buf.append(';');
            if (this.increment != null) {
                buf.append(' ');
                this.increment.toString(mw, buf, indent);
            }
            buf.append(") {\n");
            for (int i = 0; i < this.statements.size(); ++i) {
                if (i != 0) {
                    buf.append('\n');
                }
                Statement stmt = (Statement)this.statements.get(i);
                stmt.toString(mw, buf, indent + 1);
            }
            buf.append('\n');
            mw.ident(buf, indent);
            buf.append("}");
        }
    }

    public static class WhileStmt
    extends Block
    implements Statement {
        final Opcodes.Op condition;

        public WhileStmt(Opcodes.Op condition) {
            this.condition = condition;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("while (");
            this.condition.toString(mw, buf, indent);
            buf.append(") {\n");
            for (int i = 0; i < this.statements.size(); ++i) {
                if (i != 0) {
                    buf.append('\n');
                }
                Statement stmt = (Statement)this.statements.get(i);
                stmt.toString(mw, buf, indent + 1);
            }
            buf.append('\n');
            mw.ident(buf, indent);
            buf.append("}");
        }
    }

    public static class SwitchStmt
    implements Statement {
        final Opcodes.Op op;
        final int[] hashKeys;
        final Block[] lables;
        final Block dflt;

        public SwitchStmt(Opcodes.Op op, int[] hashKeys) {
            this.op = op;
            this.hashKeys = hashKeys;
            this.lables = new Block[hashKeys.length];
            for (int i = 0; i < this.lables.length; ++i) {
                this.lables[i] = new Block();
            }
            this.dflt = new Block();
        }

        public int labels() {
            return this.lables.length;
        }

        public Block label(int index) {
            return this.lables[index];
        }

        public int labelKey(int index) {
            return this.hashKeys[index];
        }

        public Block dflt() {
            return this.dflt;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append("switch (");
            this.op.toString(mw, buf, indent);
            buf.append(") {\n");
            for (int i = 0; i < this.lables.length; ++i) {
                mw.ident(buf, ++indent);
                ++indent;
                List<Statement> statements = this.lables[i].statements;
                boolean brace = statements.stream().anyMatch(e -> e instanceof DeclareStmt);
                buf.append("case ").append(this.hashKeys[i]);
                if (brace) {
                    buf.append(": {\n");
                } else {
                    buf.append(":\n");
                }
                for (int j = 0; j < statements.size(); ++j) {
                    if (j != 0) {
                        buf.append('\n');
                    }
                    statements.get(j).toString(mw, buf, indent);
                }
                buf.append('\n');
                --indent;
                if (brace) {
                    mw.ident(buf, indent);
                    buf.append("}\n");
                }
                --indent;
            }
            mw.ident(buf, ++indent);
            List<Statement> statements = this.dflt.statements;
            boolean brace = statements.stream().anyMatch(e -> e instanceof DeclareStmt);
            if (brace) {
                buf.append("default : {\n");
            } else {
                buf.append("default :\n");
            }
            ++indent;
            for (int j = 0; j < statements.size(); ++j) {
                if (j != 0) {
                    buf.append('\n');
                }
                statements.get(j).toString(mw, buf, indent);
            }
            if (!statements.isEmpty()) {
                buf.append('\n');
            }
            mw.ident(buf, indent);
            buf.append("break;\n");
            --indent;
            if (brace) {
                mw.ident(buf, indent);
                buf.append("}\n");
            }
            mw.ident(buf, --indent);
            buf.append("}");
        }
    }

    public static class DeclareStmt
    implements Statement {
        public final String type;
        public final Opcodes.OpName name;
        public final Opcodes.Op initValue;

        public DeclareStmt(String type, Opcodes.OpName name, Opcodes.Op initValue) {
            this.type = type;
            this.name = name;
            this.initValue = initValue;
        }

        @Override
        public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            mw.ident(buf, indent);
            buf.append(this.type).append(' ');
            buf.append(this.name.name);
            if (this.initValue != null) {
                if (this.type.length() >= 16) {
                    buf.append('\n');
                    mw.ident(buf, indent + 2);
                    buf.append("= ");
                } else {
                    buf.append(" = ");
                }
                this.initValue.toString(mw, buf, indent);
            }
            buf.append(';');
        }
    }

    public static interface Statement {
        default public void toString(MethodWriter mw, StringBuilder buf, int indent) {
            throw new JSONException("TODO " + this.getClass().getName());
        }
    }
}

