/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.issues;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class Issue206ParseTreeStringPretty {
    static String str;
    static ObjectMapper mapper;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.parseObject((String)str));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.parseObject((String)str));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, HashMap.class));
    }

    public void fastjson1_perf_test() {
        for (int i = 0; i < 10; ++i) {
            Issue206ParseTreeStringPretty.fastjson1_perf();
        }
    }

    public void fastjson2_perf_test() {
        for (int i = 0; i < 10; ++i) {
            Issue206ParseTreeStringPretty.fastjson2_perf();
        }
    }

    public static void fastjson2_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            JSON.parseObject((String)str);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("millis : " + millis);
    }

    public static void fastjson1_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            com.alibaba.fastjson.JSON.parseObject((String)str);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("millis : " + millis);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(Issue206ParseTreeStringPretty.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try {
            InputStream is = Issue206ParseTreeStringPretty.class.getClassLoader().getResourceAsStream("issue/issue206.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

