/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.geoip;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.geoip.GeoIP;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class GeoIPWriteString {
    static GeoIP object;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)object));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)object));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)object));
    }

    @Benchmark
    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)object));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)object));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(GeoIPWriteString.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = GeoIPWriteString.class.getClassLoader().getResourceAsStream("data/geoip.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            object = (GeoIP)JSONReader.of((String)str).read(GeoIP.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

