/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import com.alibaba.fastjson2.util.NumberUtils;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DoubleToString {
    static double d = 0.6730586701548151;
    static float f = 0.98163563f;

    @Benchmark
    public void jdk(Blackhole bh) throws Throwable {
        bh.consume((Object)Double.toString(d));
    }

    @Benchmark
    public void ryu(Blackhole bh) throws Throwable {
        byte[] bytes = new byte[24];
        int size = NumberUtils.writeDouble((byte[])bytes, (int)0, (double)d, (boolean)true);
        String str = new String(bytes, 0, 0, size);
        bh.consume((Object)str);
    }

    public void jdkFloat(Blackhole bh) throws Throwable {
        bh.consume((Object)Float.toString(f));
    }

    public void ryuFloat(Blackhole bh) throws Throwable {
        byte[] bytes = new byte[15];
        int size = NumberUtils.writeFloat((byte[])bytes, (int)0, (float)f, (boolean)false);
        String str = new String(bytes, 0, 0, size);
        bh.consume((Object)str);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(DoubleToString.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }
}

