/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class AsciiToChars {
    static final Function<byte[], char[]> TO_CHARS;
    static final MethodHandle INFLATE;
    static final byte[][] bytesArray;

    @Benchmark
    public void for_cast(Blackhole bh) throws Throwable {
        for (int i = 0; i < bytesArray.length; ++i) {
            byte[] bytes = bytesArray[i];
            char[] chars = AsciiToChars.toAsciiCharArray(bytes);
            bh.consume((Object)chars);
        }
    }

    @Benchmark
    public void lambda_cast(Blackhole bh) throws Throwable {
        for (int i = 0; i < bytesArray.length; ++i) {
            byte[] bytes = bytesArray[i];
            char[] chars = TO_CHARS.apply(bytes);
            bh.consume((Object)chars);
        }
    }

    @Benchmark
    public void mh_inflate(Blackhole bh) throws Throwable {
        if (INFLATE == null) {
            return;
        }
        for (int i = 0; i < bytesArray.length; ++i) {
            byte[] bytes = bytesArray[i];
            char[] chars = new char[bytes.length];
            INFLATE.invokeExact(bytes, 0, chars, 0, bytes.length);
            bh.consume((Object)chars);
        }
    }

    public static char[] toAsciiCharArray(byte[] bytes) {
        char[] charArray = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            charArray[i] = (char)bytes[i];
        }
        return charArray;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(AsciiToChars.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }

    static {
        Function toChars = null;
        MethodHandle inflate = null;
        if (JDKUtils.JVM_VERSION > 9) {
            try {
                Class<?> latin1Class = Class.forName("java.lang.StringLatin1");
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(latin1Class);
                MethodHandle handle = lookup.findStatic(latin1Class, "toChars", MethodType.methodType(char[].class, byte[].class));
                CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), handle, MethodType.methodType(char[].class, byte[].class));
                toChars = callSite.getTarget().invokeExact();
                inflate = lookup.findStatic(latin1Class, "inflate", MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE));
            }
            catch (Throwable latin1Class) {
                // empty catch block
            }
        }
        if (toChars == null) {
            toChars = AsciiToChars::toAsciiCharArray;
        }
        TO_CHARS = toChars;
        INFLATE = inflate;
        String[] strings = new String[]{"567988.735", "-811227.824", "17415.508", "668069.440", "77259.887", "733032.058", "44402.415", "99328.975", "759431.827", "651998.851"};
        byte[][] array2 = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            array2[i] = strings[i].getBytes();
        }
        bytesArray = array2;
    }
}

