/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.along;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.along.vo.SkillFire_S2C_Msg;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.fury.Fury;
import org.apache.fury.config.Language;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class AlongWriteBinaryArrayMapping {
    static final ObjectWriterProvider providerFeatures = new ObjectWriterProvider();
    static final JSONWriter.Context contextFeatures;
    static SkillFire_S2C_Msg object;
    static Fury fury;

    public int jsonbSize() {
        return JSONB.toBytes((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray}).length;
    }

    @Benchmark
    public void jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased}));
    }

    @Benchmark
    public void jsonbFeatures(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)object, (JSONWriter.Context)contextFeatures));
    }

    @Benchmark
    public void fury(Blackhole bh) {
        bh.consume((Object)fury.serialize((Object)object));
    }

    public int furySize() {
        return fury.serialize((Object)object).length;
    }

    public void json(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased}));
    }

    public void jsonStr(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased}));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(AlongWriteBinaryArrayMapping.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = AlongWriteBinaryArrayMapping.class.getClassLoader().getResourceAsStream("data/along.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            object = (SkillFire_S2C_Msg)JSONReader.of((String)str).read(SkillFire_S2C_Msg.class);
            fury = Fury.builder().withLanguage(Language.JAVA).withRefTracking(false).requireClassRegistration(false).withNumberCompressed(true).build();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        providerFeatures.setDisableAutoType(true);
        providerFeatures.setDisableReferenceDetect(true);
        contextFeatures = new JSONWriter.Context(providerFeatures, new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased});
    }
}

