/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.benchmark.eishay.EishayParseStringPretty;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class SpaceCheckBenchmark {
    static String str;
    static char[] chars;
    static final long SPACE = 4294981376L;

    @Benchmark
    public void spaceBitAnd(Blackhole bh) {
        int spaceCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean space;
            char ch = chars[i];
            boolean bl = space = ch <= ' ' && (1L << ch & 0x100003700L) != 0L;
            if (!space) continue;
            ++spaceCount;
        }
        bh.consume(spaceCount);
    }

    @Benchmark
    public void spaceOr(Blackhole bh) {
        int spaceCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean space;
            char ch = chars[i];
            boolean bl = space = ch == ' ' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\t' || ch == '\b';
            if (!space) continue;
            ++spaceCount;
        }
        bh.consume(spaceCount);
    }

    @Benchmark
    public void spaceOrPreCheck(Blackhole bh) {
        int spaceCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean space;
            char ch = chars[i];
            boolean bl = space = ch <= ' ' && (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\t' || ch == '\b');
            if (!space) continue;
            ++spaceCount;
        }
        bh.consume(spaceCount);
    }

    @Benchmark
    public void CharacterIsWhitespace(Blackhole bh) {
        int spaceCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            boolean space = Character.isWhitespace(ch);
            if (!space) continue;
            ++spaceCount;
        }
        bh.consume(spaceCount);
    }

    @Benchmark
    public void spaceSwitch(Blackhole bh) {
        int spaceCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            boolean space;
            char ch = chars[i];
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    space = true;
                    break;
                }
                default: {
                    space = false;
                }
            }
            if (!space) continue;
            ++spaceCount;
        }
        bh.consume(spaceCount);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(SpaceCheckBenchmark.class.getName()).mode(Mode.Throughput).warmupIterations(1).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = EishayParseStringPretty.class.getClassLoader().getResourceAsStream("data/eishay.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            chars = str.toCharArray();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

