/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.schema;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.JSONSchema;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;

public class JSONSchemaBenchmark1 {
    static final JSONSchema SCHEMA_UUID = (JSONSchema)JSONObject.of((String)"type", (Object)"string", (String)"format", (Object)"uuid").to(JSONSchema::of);
    static final JSONSchema SCHEMA_DATETIME = (JSONSchema)JSONObject.of((String)"type", (Object)"string", (String)"format", (Object)"date-time").to(JSONSchema::of);
    static final JSONSchema SCHEMA_DATE = (JSONSchema)JSONObject.of((String)"type", (Object)"string", (String)"format", (Object)"date").to(JSONSchema::of);
    static final JSONSchema SCHEMA_TIME = (JSONSchema)JSONObject.of((String)"type", (Object)"string", (String)"format", (Object)"time").to(JSONSchema::of);
    static final JSONSchema SCHEMA_NUMBER = (JSONSchema)JSONObject.of((String)"type", (Object)"number", (String)"minimum", (Object)10).to(JSONSchema::of);
    static final JSONSchema SCHEMA_INTEGER = (JSONSchema)JSONObject.of((String)"type", (Object)"integer", (String)"minimum", (Object)10).to(JSONSchema::of);

    @Benchmark
    public void format_uuid(Blackhole bh) {
        bh.consume(SCHEMA_UUID.isValid((Object)"a7f41390-39a9-4ca6-a13b-88cf07a41108"));
    }

    @Benchmark
    public void format_datetime(Blackhole bh) {
        bh.consume(SCHEMA_DATETIME.isValid((Object)"2017-07-21 12:13:14"));
    }

    @Benchmark
    public void format_date(Blackhole bh) {
        bh.consume(SCHEMA_DATE.isValid((Object)"2017-07-21"));
    }

    @Benchmark
    public void format_time(Blackhole bh) {
        bh.consume(SCHEMA_TIME.isValid((Object)"12:13:14"));
    }

    public static void format_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000000; ++i) {
            SCHEMA_NUMBER.isValid(9.0);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("millis : " + millis);
    }

    public static void format_perf_test() {
        for (int i = 0; i < 10; ++i) {
            JSONSchemaBenchmark1.format_perf();
        }
    }

    public static void main(String[] args) throws RunnerException {
        JSONSchemaBenchmark1.format_perf_test();
    }
}

