/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.EishayWriteString;
import com.alibaba.fastjson2.benchmark.eishay.mixin.ImageMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaContentMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaMixin;
import com.alibaba.fastjson2.benchmark.eishay.vo.Image;
import com.alibaba.fastjson2.benchmark.eishay.vo.Media;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteStringNoneCache {
    static MediaContent mc;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        SerializeConfig config = new SerializeConfig();
        bh.consume((Object)JSON.toJSONString((Object)mc, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        ObjectWriterProvider provider = new ObjectWriterProvider();
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc, (JSONWriter.Context)JSONFactory.createWriteContext((ObjectWriterProvider)provider, (JSONWriter.Feature[])new JSONWriter.Feature[0])));
    }

    @Benchmark
    public void fastjson2Mixin(Blackhole bh) {
        ObjectWriterProvider provider = new ObjectWriterProvider();
        provider.mixIn(MediaContent.class, MediaContentMixin.class);
        provider.mixIn(Media.class, MediaMixin.class);
        provider.mixIn(Image.class, ImageMixin.class);
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc, (JSONWriter.Context)JSONFactory.createWriteContext((ObjectWriterProvider)provider, (JSONWriter.Feature[])new JSONWriter.Feature[0])));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        bh.consume((Object)mapper.writeValueAsString((Object)mc));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)mc));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        Gson gson = new Gson();
        bh.consume((Object)gson.toJson((Object)mc));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteStringNoneCache.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(2).build();
        new Runner(options).run();
    }

    static {
        try {
            InputStream is = EishayWriteString.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            ObjectReaderProvider provider = new ObjectReaderProvider(ObjectReaderCreator.INSTANCE);
            JSONReader.Context readContext = JSONFactory.createReadContext((ObjectReaderProvider)provider, (JSONReader.Feature[])new JSONReader.Feature[0]);
            mc = (MediaContent)com.alibaba.fastjson2.JSON.parseObject((String)str, MediaContent.class, (JSONReader.Context)readContext);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

