/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayParseUTF8BytesPretty {
    static byte[] utf8Bytes;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((byte[])utf8Bytes, MediaContent.class, (Feature[])new Feature[0]));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((byte[])utf8Bytes, MediaContent.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(utf8Bytes, MediaContent.class));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume(gson.fromJson(new String(utf8Bytes, 0, utf8Bytes.length, StandardCharsets.UTF_8), HashMap.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayParseUTF8BytesPretty.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(2).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = EishayParseUTF8BytesPretty.class.getClassLoader().getResourceAsStream("data/eishay.json");
            utf8Bytes = IOUtils.toString((InputStream)is, (String)"UTF-8").getBytes(StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

