/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseTreeString;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DoubleArray20 {
    static String str;
    static ObjectMapper mapper;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, double[].class));
    }

    @Benchmark
    public void fastjson2_tree(Blackhole bh) {
        bh.consume(JSON.parse((String)str, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseBigDecimalForDoubles}));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, double[].class));
    }

    @Benchmark
    public void wastjson(Blackhole bh) throws Exception {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)str, double[].class, (ReadOption[])new ReadOption[0]));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(DoubleArray20.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).warmupIterations(3).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try {
            InputStream is = EishayParseTreeString.class.getClassLoader().getResourceAsStream("data/double_array_20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

