/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.wast;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.wast.NumberValueBean;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class NumberValueBeanCase {
    static String result;
    static Random random;
    static ObjectMapper mapper;

    @Benchmark
    public void jackson(Blackhole bh) throws JsonProcessingException {
        bh.consume(mapper.readValue(result, NumberValueBean.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)result, NumberValueBean.class));
    }

    @Benchmark
    public void wastjson(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)result, NumberValueBean.class, (ReadOption[])new ReadOption[0]));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(NumberValueBeanCase.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        random = new Random();
        mapper = new ObjectMapper();
        NumberValueBean numberValueBean = new NumberValueBean();
        numberValueBean.setValue1(random.nextInt());
        numberValueBean.setValue2(random.nextInt());
        numberValueBean.setValue3(random.nextLong());
        numberValueBean.setValue4(random.nextLong());
        numberValueBean.setValue5(random.nextFloat());
        numberValueBean.setValue6(random.nextFloat());
        numberValueBean.setValue7(random.nextDouble());
        numberValueBean.setValue8(random.nextDouble());
        numberValueBean.setValue9(1.23456789E107);
        numberValueBean.setValue10(1.23456789E-97);
        result = io.github.wycst.wast.json.JSON.toJsonString((Object)numberValueBean);
    }
}

