/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.benchmark.primitves.vo.Date20Field;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class Date20Write {
    static String str;
    static Date20Field object;
    static ObjectMapper mapper;

    public Date20Write() {
        try {
            InputStream is = Date20Write.class.getClassLoader().getResourceAsStream("data/date20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            object = (Date20Field)JSON.parseObject((String)str, Date20Field.class);
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)object));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)object));
    }

    @Benchmark
    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)object));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)object));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)object));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(Date20Write.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

