/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.gen.EishayClassGen;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayFuryWriteNoneCache {
    static final Class[] classes = new Class[10000];
    static final Object[] objects = new Object[classes.length];
    static int index;
    static JSONWriter.Feature[] features;
    static JSONWriter.Context context;

    @Benchmark
    public void fastjson2JSONB(Blackhole bh) {
        Object object = objects[index++ % objects.length];
        bh.consume((Object)JSONB.toBytes((Object)object, (JSONWriter.Context)context));
    }

    public void fury(Blackhole bh) {
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayFuryWriteNoneCache.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        features = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.IgnoreNoneSerializable, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.BeanToArray};
        context = new JSONWriter.Context(JSONFactory.getDefaultObjectWriterProvider(), features);
        try {
            InputStream is = EishayFuryWriteNoneCache.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            DynamicClassLoader classLoader = DynamicClassLoader.getInstance();
            EishayClassGen gen = new EishayClassGen();
            for (int i = 0; i < classes.length; ++i) {
                Class objectClass;
                EishayFuryWriteNoneCache.classes[i] = objectClass = gen.genMedia(classLoader, "com/alibaba/fastjson2/benchmark/eishay" + i);
                EishayFuryWriteNoneCache.objects[i] = JSONReader.of((String)str).read(objectClass);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

