/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class CartTree {
    static String str;
    static byte[] jsonbBytes;
    static ObjectMapper mapper;

    public CartTree() {
        try {
            InputStream is = CartTree.class.getClassLoader().getResourceAsStream("data/cart.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            jsonbBytes = JSONB.toBytes((Object)JSON.parseObject((String)str, Map.class), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNameAsSymbol});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((String)str, Map.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.parseObject((String)str));
    }

    @Benchmark
    public void wastjson(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)str, Map.class, (ReadOption[])new ReadOption[0]));
    }

    @Benchmark
    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume(JSONB.parseObject((byte[])jsonbBytes, Map.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, Map.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CartTree.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

