/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Thread)
public class Issue609 {
    private static final List<Student> objList = new ArrayList<Student>(100000);
    private static final List<String> strList = new ArrayList<String>(100000);
    private static final String source;

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(Issue609.class.getName()).warmupIterations(3).measurementIterations(5).forks(1).jvmArgsAppend(new String[]{"-Xms128m", "-Xmx128m"}).build();
        new Runner(opt).run();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON1ObjSeThroughput(Blackhole bh) {
        for (Student student : objList) {
            bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)student));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON1ObjDeThroughput(Blackhole bh) {
        for (String student : strList) {
            bh.consume(com.alibaba.fastjson.JSON.parseObject((String)student, Student.class));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON2ObjSeThroughput(Blackhole bh) {
        for (Student student : objList) {
            bh.consume((Object)JSON.toJSONString((Object)student));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON2ObjDeThroughput(Blackhole bh) {
        for (String student : strList) {
            bh.consume(JSON.parseObject((String)student, Student.class));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON1ArraySeThroughput(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString(objList));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON1ArrayDeThroughput(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.parseArray((String)source, Student.class));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON2ArraySeThroughput(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString(objList, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection}));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void fastJSON2ArrayDeThroughput(Blackhole bh) {
        bh.consume((Object)JSON.parseArray((String)source, Student.class));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON1ObjSeTime(Blackhole bh) {
        for (Student student : objList) {
            bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)student));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON1ObjDeTime(Blackhole bh) {
        for (String student : strList) {
            bh.consume(com.alibaba.fastjson.JSON.parseObject((String)student, Student.class));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON2ObjSeTime(Blackhole bh) {
        for (Student student : objList) {
            bh.consume((Object)JSON.toJSONString((Object)student));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON2ObjDeTime(Blackhole bh) {
        for (String student : strList) {
            bh.consume(JSON.parseObject((String)student, Student.class));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON1ArraySeTime(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString(objList));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON1ArrayDeTime(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.parseArray((String)source, Student.class));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON2ArraySeTime(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString(objList, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection}));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void fastJSON2ArrayDeTime(Blackhole bh) {
        bh.consume((Object)JSON.parseArray((String)source, Student.class));
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            Student student = new Student("\u5b66\u751f\u59d3\u540d" + i, i % 10, "\u9ed1\u9f99\u6c5f\u7701\u54c8\u5c14\u6ee8\u5e02\u5357\u65b9\u533a\u54c8\u5c14\u6ee8\u5927\u8857267\u53f7" + i);
            objList.add(student);
            strList.add(com.alibaba.fastjson.JSON.toJSONString((Object)student));
        }
        source = com.alibaba.fastjson.JSON.toJSONString(objList);
    }

    private static class Student {
        private String name;
        private int age;
        private String address;

        public Student() {
        }

        public Student(String name, int age, String address) {
            this.name = name;
            this.age = age;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }
}

