/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    public static boolean compatibleWithJavaBean = false;
    private static boolean setAccessibleEnable = true;
    private static volatile Class kotlin_metadata;
    private static volatile boolean kotlin_metadata_error;
    private static volatile boolean kotlin_class_klass_error;
    private static volatile Constructor kotlin_kclass_constructor;
    private static volatile Method kotlin_kclass_getConstructors;
    private static volatile Method kotlin_kfunction_getParameters;
    private static volatile Method kotlin_kparameter_getName;
    private static volatile boolean kotlin_error;
    private static volatile Map<Class, String[]> kotlinIgnores;
    private static volatile boolean kotlinIgnores_error;
    private static final ConcurrentMap<String, Class<?>> mappings;

    public static boolean isKotlin(Class clazz) {
        if (kotlin_metadata == null && !kotlin_metadata_error) {
            try {
                kotlin_metadata = Class.forName("kotlin.Metadata");
            }
            catch (Throwable e) {
                kotlin_metadata_error = true;
            }
        }
        if (kotlin_metadata == null) {
            return false;
        }
        return clazz.isAnnotationPresent(kotlin_metadata);
    }

    private static boolean isKotlinIgnore(Class clazz, String methodName) {
        if (kotlinIgnores == null && !kotlinIgnores_error) {
            try {
                HashMap<Class, String[]> map = new HashMap<Class, String[]>();
                Class<?> charRangeClass = Class.forName("kotlin.ranges.CharRange");
                map.put(charRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> intRangeClass = Class.forName("kotlin.ranges.IntRange");
                map.put(intRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> longRangeClass = Class.forName("kotlin.ranges.LongRange");
                map.put(longRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> floatRangeClass = Class.forName("kotlin.ranges.ClosedFloatRange");
                map.put(floatRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                Class<?> doubleRangeClass = Class.forName("kotlin.ranges.ClosedDoubleRange");
                map.put(doubleRangeClass, new String[]{"getEndInclusive", "isEmpty"});
                kotlinIgnores = map;
            }
            catch (Throwable error) {
                kotlinIgnores_error = true;
            }
        }
        if (kotlinIgnores == null) {
            return false;
        }
        Object[] ignores = kotlinIgnores.get(clazz);
        if (ignores == null) {
            return false;
        }
        return Arrays.binarySearch(ignores, methodName) >= 0;
    }

    public static String[] getKoltinConstructorParameters(Class clazz) {
        if (kotlin_kclass_constructor == null && !kotlin_class_klass_error) {
            try {
                Class<?> class_kotlin_kclass = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
                kotlin_kclass_constructor = class_kotlin_kclass.getConstructor(Class.class);
                kotlin_kclass_getConstructors = class_kotlin_kclass.getMethod("getConstructors", new Class[0]);
                Class<?> class_kotlin_kfunction = Class.forName("kotlin.reflect.KFunction");
                kotlin_kfunction_getParameters = class_kotlin_kfunction.getMethod("getParameters", new Class[0]);
                Class<?> class_kotlinn_kparameter = Class.forName("kotlin.reflect.KParameter");
                kotlin_kparameter_getName = class_kotlinn_kparameter.getMethod("getName", new Class[0]);
            }
            catch (Throwable e) {
                kotlin_class_klass_error = true;
            }
        }
        if (kotlin_kclass_constructor == null) {
            return null;
        }
        if (kotlin_error) {
            return null;
        }
        try {
            Object constructor = null;
            Object kclassImpl = kotlin_kclass_constructor.newInstance(clazz);
            Iterable it = (Iterable)kotlin_kclass_getConstructors.invoke(kclassImpl, new Object[0]);
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                List parameters = (List)kotlin_kfunction_getParameters.invoke(item, new Object[0]);
                if (constructor == null || parameters.size() != 0) {
                    constructor = item;
                }
                iterator.hasNext();
            }
            List parameters = (List)kotlin_kfunction_getParameters.invoke(constructor, new Object[0]);
            String[] names = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Object param = parameters.get(i);
                names[i] = (String)kotlin_kparameter_getName.invoke(param, new Object[0]);
            }
            return names;
        }
        catch (Throwable e) {
            kotlin_error = true;
            return null;
        }
    }

    public static final String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static final Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to byte, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static final Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static final BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0 || "null".equals(strVal)) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static final BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0 || "null".equals(strVal)) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static final Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static final Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    public static final Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        long longValue = -1L;
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            int scale = decimal.scale();
            longValue = scale >= -100 && scale <= 100 ? decimal.longValue() : decimal.longValueExact();
        } else if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        } else if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.indexOf(45) != -1) {
                String format = strVal.length() == JSON.DEFFAULT_DATE_FORMAT.length() ? JSON.DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : (strVal.length() == 29 && strVal.charAt(26) == ':' && strVal.charAt(28) == '0' ? "yyyy-MM-dd'T'HH:mm:ss.SSSXXX" : "yyyy-MM-dd HH:mm:ss.SSS")));
                SimpleDateFormat dateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                dateFormat.setTimeZone(JSON.defaultTimeZone);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    throw new JSONException("can not cast to Date, value : " + strVal);
                }
            }
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static final Long castToLong(Object value) {
        block9: {
            if (value == null) {
                return null;
            }
            if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                int scale = decimal.scale();
                if (scale >= -100 && scale <= 100) {
                    return decimal.longValue();
                }
                return decimal.longValueExact();
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.length() == 0 || "null".equals(strVal)) {
                    return null;
                }
                try {
                    return Long.parseLong(strVal);
                }
                catch (NumberFormatException scale) {
                    JSONLexer dateParser = new JSONLexer(strVal);
                    Calendar calendar = null;
                    if (dateParser.scanISO8601DateIfMatch(false)) {
                        calendar = dateParser.calendar;
                    }
                    dateParser.close();
                    if (calendar == null) break block9;
                    return calendar.getTimeInMillis();
                }
            }
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static final Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            int scale = decimal.scale();
            if (scale >= -100 && scale <= 100) {
                return decimal.intValue();
            }
            return decimal.intValueExact();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            return Integer.parseInt(strVal);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            String string = (String)value;
            return JSONLexer.decodeFast(string, 0, string.length());
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValueExact() == 1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static final <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.global);
    }

    public static final <T> T cast(Object obj, Class<T> clazz, ParserConfig mapping) {
        return TypeUtils.cast(obj, clazz, mapping, 0);
    }

    public static final <T> T cast(Object obj, Class<T> clazz, ParserConfig mapping, int features) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            Map map = (Map)obj;
            if (clazz == Object.class && !map.containsKey("@type")) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, mapping, features);
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = TypeUtils.cast(item, clazz.getComponentType(), mapping);
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if ((clazz == Character.TYPE || clazz == Character.class) && obj instanceof String && (strVal = (String)obj).length() == 1) {
            return (T)Character.valueOf(strVal.charAt(0));
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, mapping);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            Date date = TypeUtils.castToDate(obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("can not cast to : " + clazz.getName(), e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (obj instanceof String) {
            strVal = (String)obj;
            if (strVal.length() == 0 || "null".equals(strVal)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(strVal);
            }
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            T[] values;
            int ordinal;
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                return Enum.valueOf(clazz, name);
            }
            if ((obj instanceof Integer || obj instanceof Long) && (ordinal = ((Number)obj).intValue()) < (values = clazz.getEnumConstants()).length) {
                return values[ordinal];
            }
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static final <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping, 0);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type itemType;
        if (obj == null) {
            return (T)obj;
        }
        Type rawTye = type.getRawType();
        if (rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof List) {
                List listObj = (List)obj;
                int listObjSize = listObj.size();
                ArrayList<T> arrayList = new ArrayList<T>(listObjSize);
                for (int i = 0; i < listObjSize; ++i) {
                    Object item = listObj.get(i);
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping, 0)) : TypeUtils.cast(item, itemType, mapping);
                    arrayList.add(itemValue);
                }
                return (T)arrayList;
            }
        }
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping, 0)) : TypeUtils.cast(item, itemType, mapping);
                    collection.add(itemValue);
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal))) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static final <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        return TypeUtils.castToJavaBean(map, clazz, config, 0);
    }

    public static final <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config, int features) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : (value instanceof BigDecimal ? ((BigDecimal)value).intValueExact() : value.intValue());
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get("@type");
            if (iClassObject instanceof String) {
                Class<?> loadClazz;
                String className = (String)iClassObject;
                if (config == null) {
                    config = ParserConfig.global;
                }
                if ((loadClazz = config.checkAutoType(className, null, features)) == null) {
                    throw new ClassNotFoundException(className + " not found");
                }
                if (!loadClazz.equals(clazz)) {
                    return (T)TypeUtils.castToJavaBean(map, loadClazz, config, features);
                }
            }
            if (clazz.isInterface()) {
                ObjectDeserializer deserializer;
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                if (config == null) {
                    config = ParserConfig.getGlobalInstance();
                }
                if ((deserializer = config.getDeserializer(clazz)) != null) {
                    String json = JSON.toJSONString(object);
                    return JSON.parseObject(json, clazz);
                }
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            if (clazz == String.class && map instanceof JSONObject) {
                return (T)map.toString();
            }
            if (config == null) {
                config = ParserConfig.global;
            }
            JavaBeanDeserializer javaBeanDeser = null;
            ObjectDeserializer deserizer = config.getDeserializer(clazz);
            if (deserizer instanceof JavaBeanDeserializer) {
                javaBeanDeser = (JavaBeanDeserializer)deserizer;
            }
            if (javaBeanDeser == null) {
                throw new JSONException("can not get javaBeanDeserializer");
            }
            return (T)javaBeanDeser.createInstance(map, config);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public static Class<?> getClassFromMapping(String className) {
        return (Class)mappings.get(className);
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        return TypeUtils.loadClass(className, classLoader, false);
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader, boolean cache) {
        if (className == null || className.length() == 0) {
            return null;
        }
        if (className.length() >= 256) {
            throw new JSONException("className too long. " + className);
        }
        Class<?> clazz = (Class<?>)mappings.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (className.charAt(0) == '[') {
            Class<?> componentType = TypeUtils.loadClass(className.substring(1), classLoader, false);
            if (componentType == null) {
                return null;
            }
            return Array.newInstance(componentType, 0).getClass();
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            String newClassName = className.substring(1, className.length() - 1);
            return TypeUtils.loadClass(newClassName, classLoader, false);
        }
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                if (cache) {
                    mappings.put(className, clazz);
                }
                return clazz;
            }
        }
        catch (Exception newClassName) {
            // empty catch block
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && contextClassLoader != classLoader) {
                clazz = contextClassLoader.loadClass(className);
                if (cache) {
                    mappings.put(className, clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = Class.forName(className);
            mappings.put(className, clazz);
            return clazz;
        }
        catch (Exception exception) {
            return clazz;
        }
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, int modifiers, boolean fieldOnly, JSONType jsonType, Map<String, String> aliasMap, boolean sorted, boolean jsonFieldSupport, boolean fieldGenericSupport, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        HashMap classFieldCache = new HashMap();
        Field[] declaredFields = clazz.getDeclaredFields();
        if (!fieldOnly) {
            boolean kotlin = TypeUtils.isKotlin(clazz);
            Field[] methodList = new ArrayList();
            for (Class<?> cls = clazz; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                Method[] declaredMethods;
                for (Method method : declaredMethods = cls.getDeclaredMethods()) {
                    int modifier = method.getModifiers();
                    if ((modifier & 8) != 0 || (modifier & 2) != 0 || (modifier & 0x100) != 0 || (modifier & 4) != 0 || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || method.getReturnType() == ClassLoader.class || method.getDeclaringClass() == Object.class) continue;
                    methodList.add(method);
                }
            }
            Constructor<?>[] constructors = null;
            Annotation[][] paramAnnotationArrays = null;
            Object[] paramNames = null;
            short[] paramNameMapping = null;
            for (Method method : methodList) {
                String propertyName;
                JSONField fieldAnnotation;
                Field field;
                JSONField annotation;
                String methodName = method.getName();
                int ordinal = 0;
                int serialzeFeatures = 0;
                if (methodName.equals("getMetaClass") && method.getReturnType().getName().equals("groovy.lang.MetaClass")) continue;
                JSONField jSONField = annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                if (annotation == null && jsonFieldSupport) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (kotlin && TypeUtils.isKotlinIgnore(clazz, methodName)) continue;
                if (annotation == null && kotlin) {
                    int index;
                    int p;
                    if (constructors == null && (constructors = clazz.getDeclaredConstructors()).length == 1) {
                        paramAnnotationArrays = constructors[0].getParameterAnnotations();
                        paramNames = TypeUtils.getKoltinConstructorParameters(clazz);
                        if (paramNames != null) {
                            Object[] paramNames_sorted = new String[paramNames.length];
                            System.arraycopy(paramNames, 0, paramNames_sorted, 0, paramNames.length);
                            Arrays.sort(paramNames_sorted);
                            paramNameMapping = new short[paramNames.length];
                            for (p = 0; p < paramNames.length; p = (int)((short)(p + 1))) {
                                index = Arrays.binarySearch(paramNames_sorted, paramNames[p]);
                                paramNameMapping[index] = p;
                            }
                            paramNames = paramNames_sorted;
                        }
                    }
                    if (paramNames != null && paramNameMapping != null && methodName.startsWith("get")) {
                        Annotation[] paramAnnotations;
                        String propertyName2 = TypeUtils.decapitalize(methodName.substring(3));
                        p = Arrays.binarySearch(paramNames, propertyName2);
                        if (p < 0) {
                            for (int i = 0; i < paramNames.length; ++i) {
                                if (!propertyName2.equalsIgnoreCase((String)paramNames[i])) continue;
                                p = i;
                                break;
                            }
                        }
                        if (p >= 0 && (paramAnnotations = paramAnnotationArrays[index = paramNameMapping[p]]) != null) {
                            for (Annotation paramAnnotation : paramAnnotations) {
                                if (!(paramAnnotation instanceof JSONField)) continue;
                                annotation = (JSONField)paramAnnotation;
                                break;
                            }
                        }
                    }
                }
                boolean fieldAnnotationExists = false;
                if (annotation != null) {
                    if (!annotation.serialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName3 = annotation.name();
                        fieldAnnotationExists = true;
                        if (aliasMap != null && (propertyName3 = aliasMap.get(propertyName3)) == null) continue;
                        TypeUtils.setAccessible(clazz, method, modifiers);
                        fieldInfoMap.put(propertyName3, new FieldInfo(propertyName3, method, null, clazz, null, ordinal, serialzeFeatures, annotation, null, true));
                        continue;
                    }
                }
                if (methodName.startsWith("get")) {
                    String propertyName2;
                    if (methodName.length() < 4 || methodName.equals("getClass")) continue;
                    char c3 = methodName.charAt(3);
                    if (Character.isUpperCase(c3)) {
                        if (compatibleWithJavaBean) {
                            String propertyName4 = TypeUtils.decapitalize(methodName.substring(3));
                        } else {
                            propertyName2 = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                        }
                    } else if (c3 == '_') {
                        propertyName2 = methodName.substring(4);
                    } else if (c3 == 'f') {
                        propertyName2 = methodName.substring(3);
                    } else {
                        if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                        propertyName2 = TypeUtils.decapitalize(methodName.substring(3));
                    }
                    if (TypeUtils.isJSONTypeIgnore(clazz, jsonType, propertyName2)) continue;
                    field = TypeUtils.getField(clazz, propertyName2, declaredFields, classFieldCache);
                    fieldAnnotation = null;
                    if (field != null) {
                        JSONField jSONField2 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                        if (fieldAnnotation != null) {
                            if (!fieldAnnotation.serialize()) continue;
                            ordinal = fieldAnnotation.ordinal();
                            serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                            if (fieldAnnotation.name().length() != 0) {
                                propertyName2 = fieldAnnotation.name();
                                fieldAnnotationExists = true;
                                if (aliasMap != null && (propertyName2 = aliasMap.get(propertyName2)) == null) continue;
                            }
                        }
                    }
                    if (propertyNamingStrategy != null && !fieldAnnotationExists) {
                        propertyName2 = propertyNamingStrategy.translate(propertyName2);
                    }
                    if (aliasMap != null && (propertyName2 = aliasMap.get(propertyName2)) == null) continue;
                    TypeUtils.setAccessible(clazz, method, modifiers);
                    fieldInfoMap.put(propertyName2, new FieldInfo(propertyName2, method, field, clazz, null, ordinal, serialzeFeatures, annotation, fieldAnnotation, fieldGenericSupport));
                }
                if (!methodName.startsWith("is") || methodName.length() < 3) continue;
                char c2 = methodName.charAt(2);
                if (Character.isUpperCase(c2)) {
                    propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(2)) : Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                } else if (c2 == '_') {
                    propertyName = methodName.substring(3);
                } else {
                    if (c2 != 'f') continue;
                    propertyName = methodName.substring(2);
                }
                if (TypeUtils.isJSONTypeIgnore(clazz, jsonType, propertyName)) continue;
                field = TypeUtils.getField(clazz, propertyName, declaredFields, classFieldCache);
                if (field == null) {
                    field = TypeUtils.getField(clazz, methodName, declaredFields, classFieldCache);
                }
                fieldAnnotation = null;
                if (field != null) {
                    JSONField jSONField3 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                    if (fieldAnnotation != null) {
                        if (!fieldAnnotation.serialize()) continue;
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName = fieldAnnotation.name();
                            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                        }
                    }
                }
                if (propertyNamingStrategy != null) {
                    propertyName = propertyNamingStrategy.translate(propertyName);
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                TypeUtils.setAccessible(clazz, field, modifiers);
                TypeUtils.setAccessible(clazz, method, modifiers);
                fieldInfoMap.put(propertyName, new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, annotation, fieldAnnotation, fieldGenericSupport));
            }
        }
        ArrayList<Field> classfields = new ArrayList<Field>(declaredFields.length);
        for (Field f : declaredFields) {
            if ((f.getModifiers() & 8) != 0 || f.getName().equals("this$0") || (f.getModifiers() & 1) == 0) continue;
            classfields.add(f);
        }
        for (Class c = clazz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if ((f.getModifiers() & 8) != 0 || (f.getModifiers() & 1) == 0) continue;
                classfields.add(f);
            }
        }
        for (Field field : classfields) {
            JSONField fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName = field.getName();
            if (fieldAnnotation != null) {
                if (!fieldAnnotation.serialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            if (fieldInfoMap.containsKey(propertyName)) continue;
            TypeUtils.setAccessible(clazz, field, modifiers);
            fieldInfoMap.put(propertyName, new FieldInfo(propertyName, null, field, clazz, null, ordinal, serialzeFeatures, null, fieldAnnotation, fieldGenericSupport));
        }
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        boolean containsAll = false;
        String[] orders = null;
        if (jsonType != null) {
            orders = jsonType.orders();
            if (orders != null && orders.length == fieldInfoMap.size()) {
                containsAll = true;
                for (String string : orders) {
                    if (fieldInfoMap.containsKey(string)) continue;
                    containsAll = false;
                    break;
                }
            } else {
                containsAll = false;
            }
        }
        if (containsAll) {
            for (String string : orders) {
                FieldInfo fieldInfo = (FieldInfo)fieldInfoMap.get(string);
                fieldInfoList.add(fieldInfo);
            }
        } else {
            for (FieldInfo fieldInfo : fieldInfoMap.values()) {
                fieldInfoList.add(fieldInfo);
            }
            if (sorted) {
                Collections.sort(fieldInfoList);
            }
        }
        return fieldInfoList;
    }

    public static JSONField getSupperMethodAnnotation(Class<?> clazz, Method method) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            for (Method interfaceMethod : interfaceClass.getMethods()) {
                JSONField annotation;
                Class<?>[] parameterTypes;
                Class<?>[] interfaceParameterTypes;
                if (!interfaceMethod.getName().equals(method.getName()) || (interfaceParameterTypes = interfaceMethod.getParameterTypes()).length != (parameterTypes = method.getParameterTypes()).length) continue;
                boolean match = true;
                for (int i = 0; i < interfaceParameterTypes.length; ++i) {
                    if (interfaceParameterTypes[i].equals(parameterTypes[i])) continue;
                    match = false;
                    break;
                }
                if (!match || (annotation = interfaceMethod.getAnnotation(JSONField.class)) == null) continue;
                return annotation;
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        if (Modifier.isAbstract(superClass.getModifiers())) {
            Class<?>[] types = method.getParameterTypes();
            for (Method interfaceMethod : superClass.getMethods()) {
                JSONField annotation;
                Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                if (interfaceTypes.length != types.length || !interfaceMethod.getName().equals(method.getName())) continue;
                boolean match = true;
                for (int i = 0; i < types.length; ++i) {
                    if (interfaceTypes[i].equals(types[i])) continue;
                    match = false;
                    break;
                }
                if (!match || (annotation = interfaceMethod.getAnnotation(JSONField.class)) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, JSONType jsonType, String propertyName) {
        Class<?> superClass;
        if (jsonType != null && jsonType.ignores() != null) {
            for (String item : jsonType.ignores()) {
                if (!propertyName.equalsIgnoreCase(item)) continue;
                return true;
            }
        }
        return (superClass = clazz.getSuperclass()) != Object.class && superClass != null && TypeUtils.isJSONTypeIgnore(superClass, superClass.getAnnotation(JSONType.class), propertyName);
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            Type superType = ((Class)type).getGenericSuperclass();
            return superType != Object.class && TypeUtils.isGenericParamType(superType);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        return type instanceof Class ? TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass()) : type;
    }

    public static Class<?> getClass(Type type) {
        Type[] upperBounds;
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return (Class)((TypeVariable)type).getBounds()[0];
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return TypeUtils.getClass(upperBounds[0]);
        }
        return Object.class;
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean setAccessible(Class<?> clazz, Member member, int classMofifiers) {
        if (member == null || !setAccessibleEnable) {
            return false;
        }
        Class<?> supperClass = clazz.getSuperclass();
        if ((supperClass == null || supperClass == Object.class) && (member.getModifiers() & 1) != 0 && (classMofifiers & 1) != 0) {
            return false;
        }
        AccessibleObject obj = (AccessibleObject)((Object)member);
        try {
            obj.setAccessible(true);
            return true;
        }
        catch (AccessControlException error) {
            setAccessibleEnable = false;
            return false;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName, Field[] declaredFields) {
        return TypeUtils.getField(clazz, fieldName, declaredFields, null);
    }

    public static Field getField(Class<?> clazz, String fieldName, Field[] declaredFields, Map<Class<?>, Field[]> classFieldCache) {
        Field field = TypeUtils.getField0(clazz, fieldName, declaredFields, classFieldCache);
        if (field == null) {
            field = TypeUtils.getField0(clazz, "_" + fieldName, declaredFields, classFieldCache);
        }
        if (field == null) {
            field = TypeUtils.getField0(clazz, "m_" + fieldName, declaredFields, classFieldCache);
        }
        if (field == null) {
            String mName = "m" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            field = TypeUtils.getField0(clazz, mName, declaredFields, classFieldCache);
        }
        return field;
    }

    private static Field getField0(Class<?> clazz, String fieldName, Field[] declaredFields, Map<Class<?>, Field[]> classFieldCache) {
        Field[] superClassFields;
        for (Field item : declaredFields) {
            char c1;
            char c0;
            String itemName = item.getName();
            if (fieldName.equals(itemName)) {
                return item;
            }
            if (fieldName.length() <= 2 || (c0 = fieldName.charAt(0)) < 'a' || c0 > 'z' || (c1 = fieldName.charAt(1)) < 'A' || c1 > 'Z' || !fieldName.equalsIgnoreCase(itemName)) continue;
            return item;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            return null;
        }
        Field[] fieldArray = superClassFields = classFieldCache != null ? classFieldCache.get(superClass) : null;
        if (superClassFields == null) {
            superClassFields = superClass.getDeclaredFields();
            if (classFieldCache != null) {
                classFieldCache.put(superClass, superClassFields);
            }
        }
        return TypeUtils.getField(superClass, fieldName, superClassFields, classFieldCache);
    }

    public static Type getCollectionItemType(Type fieldType) {
        Object itemType = null;
        Class clazz = null;
        if (fieldType instanceof ParameterizedType) {
            WildcardType wildcardType;
            Type[] upperBounds;
            Type actualTypeArgument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)actualTypeArgument).getUpperBounds()).length == 1) {
                actualTypeArgument = upperBounds[0];
            }
            itemType = actualTypeArgument;
        } else if (fieldType instanceof Class && !(clazz = (Class)fieldType).getName().startsWith("java.")) {
            Type superClass = clazz.getGenericSuperclass();
            itemType = TypeUtils.getCollectionItemType(superClass);
        }
        if (itemType == null) {
            itemType = Object.class;
        }
        return itemType;
    }

    public static Object defaultValue(Class<?> fieldType) {
        if (fieldType == Byte.TYPE) {
            return (byte)0;
        }
        if (fieldType == Short.TYPE) {
            return (short)0;
        }
        if (fieldType == Integer.TYPE) {
            return 0;
        }
        if (fieldType == Long.TYPE) {
            return 0L;
        }
        if (fieldType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (fieldType == Double.TYPE) {
            return 0.0;
        }
        if (fieldType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (fieldType == Character.TYPE) {
            return Character.valueOf('0');
        }
        return null;
    }

    public static boolean getArgument(Type[] typeArgs, TypeVariable[] typeVariables, Type[] arguments) {
        if (arguments == null || typeVariables.length == 0) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < typeArgs.length; ++i) {
            Type typeArg = typeArgs[i];
            if (typeArg instanceof ParameterizedType) {
                ParameterizedType p_typeArg = (ParameterizedType)typeArg;
                Type[] p_typeArg_args = p_typeArg.getActualTypeArguments();
                boolean p_changed = TypeUtils.getArgument(p_typeArg_args, typeVariables, arguments);
                if (!p_changed) continue;
                typeArgs[i] = new ParameterizedTypeImpl(p_typeArg_args, p_typeArg.getOwnerType(), p_typeArg.getRawType());
                changed = true;
                continue;
            }
            if (!(typeArg instanceof TypeVariable)) continue;
            for (int j = 0; j < typeVariables.length; ++j) {
                if (!typeArg.equals(typeVariables[j])) continue;
                typeArgs[i] = arguments[j];
                changed = true;
            }
        }
        return changed;
    }

    public static double parseDouble(String str) {
        int len = str.length();
        if (len > 10) {
            return Double.parseDouble(str);
        }
        boolean negative = false;
        long longValue = 0L;
        int scale = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '-' && i == 0) {
                negative = true;
                continue;
            }
            if (ch == '.') {
                if (scale != 0) {
                    return Double.parseDouble(str);
                }
                scale = len - i - 1;
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                int digit = ch - 48;
                longValue = longValue * 10L + (long)digit;
                continue;
            }
            return Double.parseDouble(str);
        }
        if (negative) {
            longValue = -longValue;
        }
        switch (scale) {
            case 0: {
                return longValue;
            }
            case 1: {
                return (double)longValue / 10.0;
            }
            case 2: {
                return (double)longValue / 100.0;
            }
            case 3: {
                return (double)longValue / 1000.0;
            }
            case 4: {
                return (double)longValue / 10000.0;
            }
            case 5: {
                return (double)longValue / 100000.0;
            }
            case 6: {
                return (double)longValue / 1000000.0;
            }
            case 7: {
                return (double)longValue / 1.0E7;
            }
            case 8: {
                return (double)longValue / 1.0E8;
            }
            case 9: {
                return (double)longValue / 1.0E9;
            }
        }
        return Double.parseDouble(str);
    }

    public static float parseFloat(String str) {
        int len = str.length();
        if (len >= 10) {
            return Float.parseFloat(str);
        }
        boolean negative = false;
        long longValue = 0L;
        int scale = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '-' && i == 0) {
                negative = true;
                continue;
            }
            if (ch == '.') {
                if (scale != 0) {
                    return Float.parseFloat(str);
                }
                scale = len - i - 1;
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                int digit = ch - 48;
                longValue = longValue * 10L + (long)digit;
                continue;
            }
            return Float.parseFloat(str);
        }
        if (negative) {
            longValue = -longValue;
        }
        switch (scale) {
            case 0: {
                return longValue;
            }
            case 1: {
                return (float)longValue / 10.0f;
            }
            case 2: {
                return (float)longValue / 100.0f;
            }
            case 3: {
                return (float)longValue / 1000.0f;
            }
            case 4: {
                return (float)longValue / 10000.0f;
            }
            case 5: {
                return (float)longValue / 100000.0f;
            }
            case 6: {
                return (float)longValue / 1000000.0f;
            }
            case 7: {
                return (float)longValue / 1.0E7f;
            }
            case 8: {
                return (float)longValue / 1.0E8f;
            }
            case 9: {
                return (float)longValue / 1.0E9f;
            }
        }
        return Float.parseFloat(str);
    }

    public static long fnv_64_lower(String key) {
        if (key == null) {
            return 0L;
        }
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '_' || ch == '-') continue;
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            hashCode ^= (long)ch;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    public static void addMapping(String className, Class<?> clazz) {
        mappings.put(className, clazz);
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    static {
        mappings = new ConcurrentHashMap(36, 0.75f, 1);
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put("[B", byte[].class);
        mappings.put("[S", short[].class);
        mappings.put("[I", int[].class);
        mappings.put("[J", long[].class);
        mappings.put("[F", float[].class);
        mappings.put("[D", double[].class);
        mappings.put("[C", char[].class);
        mappings.put("[Z", boolean[].class);
        mappings.put("java.util.HashMap", HashMap.class);
        mappings.put("java.util.TreeMap", TreeMap.class);
        mappings.put("java.util.Date", Date.class);
        mappings.put("com.alibaba.fastjson.JSONObject", JSONObject.class);
        mappings.put("java.util.concurrent.ConcurrentHashMap", ConcurrentHashMap.class);
        mappings.put("java.text.SimpleDateFormat", SimpleDateFormat.class);
        mappings.put("java.lang.StackTraceElement", StackTraceElement.class);
        mappings.put("java.lang.RuntimeException", RuntimeException.class);
    }
}

