/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Method method;
    public final Field field;
    public final boolean fieldAccess;
    public final boolean fieldTransient;
    private int ordinal = 0;
    public final Class<?> fieldClass;
    public final Type fieldType;
    public final Class<?> declaringClass;
    public final boolean getOnly;
    private final JSONField fieldAnnotation;
    private final JSONField methodAnnotation;
    public final boolean isEnum;
    public final String format;
    public final long nameHashCode;
    public final String[] alternateNames;

    public FieldInfo(String name, Class<?> declaringClass, Class<?> fieldClass, Type fieldType, Field field, int ordinal, int serialzeFeatures) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.fieldClass = fieldClass;
        this.fieldType = fieldType;
        this.method = null;
        this.field = field;
        this.ordinal = ordinal;
        this.isEnum = fieldClass.isEnum() && !JSONAware.class.isAssignableFrom(fieldClass);
        this.fieldAnnotation = null;
        this.methodAnnotation = null;
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = (modifiers & 1) != 0 || this.method == null;
            this.fieldTransient = Modifier.isTransient(modifiers);
        } else {
            this.fieldAccess = false;
            this.fieldTransient = false;
        }
        this.getOnly = false;
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        this.nameHashCode = hashCode;
        this.format = null;
        this.alternateNames = new String[0];
    }

    public FieldInfo(String name, Method method, Field field, Class<?> clazz, Type type, int ordinal, int serialzeFeatures, JSONField methodAnnotation, JSONField fieldAnnotation, boolean fieldGenericSupport) {
        Type fieldType;
        Class<?> fieldClass;
        this.name = name;
        this.method = method;
        this.field = field;
        this.ordinal = ordinal;
        this.methodAnnotation = methodAnnotation;
        this.fieldAnnotation = fieldAnnotation;
        JSONField annotation = this.getAnnotation();
        String format = null;
        if (annotation != null) {
            format = annotation.format();
            if (format.trim().length() == 0) {
                format = null;
            }
            this.alternateNames = annotation.alternateNames();
        } else {
            this.alternateNames = new String[0];
        }
        this.format = format;
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = method == null || (modifiers & 1) != 0 && method.getReturnType() == field.getType();
            this.fieldTransient = (modifiers & 0x80) != 0;
        } else {
            this.fieldAccess = false;
            this.fieldTransient = false;
        }
        long hashCode = -3750763034362895579L;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        this.nameHashCode = hashCode;
        if (method != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                fieldClass = parameterTypes[0];
                fieldType = fieldClass == Class.class || fieldClass == String.class || fieldClass.isPrimitive() ? fieldClass : (fieldGenericSupport ? method.getGenericParameterTypes()[0] : fieldClass);
                this.getOnly = false;
            } else {
                fieldClass = method.getReturnType();
                fieldType = fieldClass == Class.class ? fieldClass : (fieldGenericSupport ? method.getGenericReturnType() : fieldClass);
                this.getOnly = true;
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            fieldClass = field.getType();
            fieldType = fieldClass.isPrimitive() || fieldClass == String.class || fieldClass.isEnum() ? fieldClass : (fieldGenericSupport ? field.getGenericType() : fieldClass);
            this.declaringClass = field.getDeclaringClass();
            this.getOnly = Modifier.isFinal(field.getModifiers());
        }
        if (clazz != null && fieldClass == Object.class && fieldType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)fieldType;
            Type genericFieldType = null;
            Type[] arguments = null;
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)((Object)type);
                arguments = ptype.getActualTypeArguments();
            }
            for (Class<?> c = clazz; c != null && c != Object.class && c != this.declaringClass; c = c.getSuperclass()) {
                Type superType = c.getGenericSuperclass();
                if (!(superType instanceof ParameterizedType)) continue;
                ParameterizedType p_superType = (ParameterizedType)superType;
                Type[] p_superType_args = p_superType.getActualTypeArguments();
                TypeUtils.getArgument(p_superType_args, c.getTypeParameters(), arguments);
                arguments = p_superType_args;
            }
            if (arguments != null) {
                TypeVariable<Class<?>>[] typeVariables = this.declaringClass.getTypeParameters();
                for (int j = 0; j < typeVariables.length; ++j) {
                    if (!tv.equals(typeVariables[j])) continue;
                    genericFieldType = arguments[j];
                    break;
                }
            }
            if (genericFieldType != null) {
                this.fieldClass = TypeUtils.getClass(genericFieldType);
                this.fieldType = genericFieldType;
                this.isEnum = fieldClass.isEnum() && !JSONAware.class.isAssignableFrom(fieldClass);
                return;
            }
        }
        Type genericFieldType = fieldType;
        if (!(fieldType instanceof Class) && (genericFieldType = FieldInfo.getFieldType(clazz, type != null ? type : clazz, fieldType)) != fieldType) {
            if (genericFieldType instanceof ParameterizedType) {
                fieldClass = TypeUtils.getClass(genericFieldType);
            } else if (genericFieldType instanceof Class) {
                fieldClass = TypeUtils.getClass(genericFieldType);
            }
        }
        this.fieldType = genericFieldType;
        this.fieldClass = fieldClass;
        this.isEnum = !fieldClass.isArray() && fieldClass.isEnum() && !JSONAware.class.isAssignableFrom(fieldClass);
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type fieldType) {
        if (clazz == null || type == null) {
            return fieldType;
        }
        if (fieldType instanceof GenericArrayType) {
            Type componentTypeX;
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Type componentType = genericArrayType.getGenericComponentType();
            if (componentType != (componentTypeX = FieldInfo.getFieldType(clazz, type, componentType))) {
                Class<?> fieldTypeX = Array.newInstance(TypeUtils.getClass(componentTypeX), 0).getClass();
                return fieldTypeX;
            }
            return fieldType;
        }
        if (!TypeUtils.isGenericParamType(type)) {
            return fieldType;
        }
        if (fieldType instanceof TypeVariable) {
            ParameterizedType paramType = (ParameterizedType)TypeUtils.getGenericParamType(type);
            Class<?> parameterizedClass = TypeUtils.getClass(paramType);
            TypeVariable typeVar = (TypeVariable)fieldType;
            for (int i = 0; i < parameterizedClass.getTypeParameters().length; ++i) {
                if (!parameterizedClass.getTypeParameters()[i].getName().equals(typeVar.getName())) continue;
                fieldType = paramType.getActualTypeArguments()[i];
                return fieldType;
            }
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
            Type[] arguments = parameterizedFieldType.getActualTypeArguments();
            boolean changed = false;
            TypeVariable<Class<?>>[] typeVariables = null;
            Type[] actualTypes = null;
            ParameterizedType paramType = null;
            if (type instanceof ParameterizedType) {
                paramType = (ParameterizedType)type;
                typeVariables = clazz.getTypeParameters();
            } else if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
                paramType = (ParameterizedType)clazz.getGenericSuperclass();
                typeVariables = clazz.getSuperclass().getTypeParameters();
            }
            for (int i = 0; i < arguments.length && paramType != null; ++i) {
                Type feildTypeArguement = arguments[i];
                if (!(feildTypeArguement instanceof TypeVariable)) continue;
                TypeVariable typeVar = (TypeVariable)feildTypeArguement;
                for (int j = 0; j < typeVariables.length; ++j) {
                    if (!typeVariables[j].getName().equals(typeVar.getName())) continue;
                    if (actualTypes == null) {
                        actualTypes = paramType.getActualTypeArguments();
                    }
                    arguments[i] = actualTypes[j];
                    changed = true;
                }
            }
            if (changed) {
                fieldType = new ParameterizedTypeImpl(arguments, parameterizedFieldType.getOwnerType(), parameterizedFieldType.getRawType());
                return fieldType;
            }
        }
        return fieldType;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(FieldInfo o) {
        if (this.ordinal < o.ordinal) {
            return -1;
        }
        if (this.ordinal > o.ordinal) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public boolean equals(FieldInfo o) {
        if (o == this) {
            return true;
        }
        return this.compareTo(o) == 0;
    }

    public JSONField getAnnotation() {
        if (this.fieldAnnotation != null) {
            return this.fieldAnnotation;
        }
        return this.methodAnnotation;
    }

    public Object get(Object javaObject) throws IllegalAccessException, InvocationTargetException {
        if (this.fieldAccess) {
            return this.field.get(javaObject);
        }
        Object value = this.method.invoke(javaObject, new Object[0]);
        return value;
    }

    public void set(Object javaObject, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.invoke(javaObject, value);
            return;
        }
        this.field.set(javaObject, value);
    }
}

