/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final ArrayCodec instance = new ArrayCodec();

    private ArrayCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        Object[] array = (Object[])object;
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        int size = array.length;
        int end = size - 1;
        if (end == -1) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.context;
        serializer.setContext(context, object, fieldName, 0);
        try {
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            out.write(91);
            if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                serializer.incrementIndent();
                serializer.println();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        out.write(44);
                        serializer.println();
                    }
                    serializer.write(array[i]);
                }
                serializer.decrementIdent();
                serializer.println();
                out.write(93);
                return;
            }
            for (int i = 0; i < end; ++i) {
                Object item = array[i];
                if (item == null) {
                    out.append("null,");
                    continue;
                }
                if (serializer.references != null && serializer.references.containsKey(item)) {
                    serializer.writeReference(item);
                } else {
                    Class<?> clazz = item.getClass();
                    if (clazz == preClazz) {
                        preWriter.write(serializer, item, null, null);
                    } else {
                        preClazz = clazz;
                        preWriter = serializer.config.get(clazz);
                        preWriter.write(serializer, item, null, null);
                    }
                }
                out.write(44);
            }
            Object item = array[end];
            if (item == null) {
                out.append("null]");
            } else {
                if (serializer.references != null && serializer.references.containsKey(item)) {
                    serializer.writeReference(item);
                } else {
                    serializer.writeWithFieldName(item, end);
                }
                out.write(93);
            }
        }
        finally {
            serializer.context = context;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (type == char[].class) {
            if (token == 4) {
                String val = lexer.stringVal();
                lexer.nextToken(16);
                return (T)val.toCharArray();
            }
            if (token == 2) {
                Number val = lexer.integerValue();
                lexer.nextToken(16);
                return (T)val.toString().toCharArray();
            }
            Object value = parser.parse();
            return (T)JSON.toJSONString(value).toCharArray();
        }
        if (token == 4) {
            byte[] bytes = lexer.bytesValue();
            lexer.nextToken(16);
            return (T)bytes;
        }
        Class clazz = (Class)type;
        Class<?> componentClass = clazz.getComponentType();
        JSONArray array = new JSONArray();
        parser.parseArray(componentClass, array, fieldName);
        return this.toObjectArray(parser, componentClass, array);
    }

    private <T> T toObjectArray(DefaultJSONParser parser, Class<?> componentType, JSONArray array) {
        if (array == null) {
            return null;
        }
        int size = array.size();
        Object objArray = Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            Object value = array.get(i);
            if (value == array) {
                Array.set(objArray, i, objArray);
                continue;
            }
            Object element = componentType.isArray() ? (componentType.isInstance(value) ? value : this.toObjectArray(parser, componentType, (JSONArray)value)) : TypeUtils.cast(value, componentType, parser.config);
            Array.set(objArray, i, element);
        }
        array.setRelatedArray(objArray);
        array.setComponentType(componentType);
        return (T)objArray;
    }
}

