/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public final class SerializeWriter
extends Writer {
    protected char[] buf;
    protected int count;
    private static final ThreadLocal<char[]> bufLocal;
    protected int features;
    protected final Writer writer;
    static final int[] sizeTable;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final char[] ascii_chars;
    static final byte[] specicalFlags_doubleQuotes;
    static final byte[] specicalFlags_singleQuotes;
    static final char[] replaceChars;
    public static final char[] DIGITS;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this.writer = writer;
        this.features = JSON.DEFAULT_GENERATE_FEATURE;
        this.buf = bufLocal.get();
        if (bufLocal != null) {
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
    }

    public SerializeWriter(SerializerFeature ... features) {
        this(null, 0, features);
    }

    public SerializeWriter(Writer writer, int featuresValue, SerializerFeature[] features) {
        this.writer = writer;
        this.buf = bufLocal.get();
        if (this.buf != null) {
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
        for (SerializerFeature feature : features) {
            featuresValue |= feature.mask;
        }
        this.features = featuresValue;
    }

    public SerializeWriter(int initialSize) {
        this(null, initialSize);
    }

    public SerializeWriter(Writer writer, int initialSize) {
        this.writer = writer;
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.mask) : (this.features &= ~feature.mask);
    }

    public boolean isEnabled(SerializerFeature feature) {
        return (this.features & feature.mask) != 0;
    }

    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                this.flush();
                newcount = 1;
            }
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                int rest;
                do {
                    rest = this.buf.length - this.count;
                    System.arraycopy(c, off, this.buf, this.count, rest);
                    this.count = this.buf.length;
                    this.flush();
                    off += rest;
                } while ((len -= rest) > this.buf.length);
                newcount = len;
            }
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    protected void expandCapacity(int minimumCapacity) {
        int newCapacity = this.buf.length * 3 / 2 + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }

    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                int rest;
                do {
                    rest = this.buf.length - this.count;
                    str.getChars(off, off + rest, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    off += rest;
                } while ((len -= rest) > this.buf.length);
                newcount = len;
            }
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, String charsetName) throws IOException {
        this.writeTo(out, Charset.forName(charsetName));
    }

    public void writeTo(OutputStream out, Charset charset) throws IOException {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset.name());
        out.write(bytes);
    }

    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    public SerializeWriter append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public byte[] toBytes(String charsetName) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        try {
            return new String(this.buf, 0, this.count).getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONException("toBytes error", e);
        }
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= 8192) {
            bufLocal.set(this.buf);
        }
        this.buf = null;
    }

    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        this.write(text, 0, text.length());
    }

    public void writeInt(int i) {
        int newcount;
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int x = i < 0 ? -i : i;
        int j = 0;
        while (true) {
            if (x <= sizeTable[j]) break;
            ++j;
        }
        int size = j + 1;
        if (i < 0) {
            ++size;
        }
        if ((newcount = this.count + size) > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                char[] chars = new char[size];
                SerializeWriter.getChars(i, size, chars);
                this.write(chars, 0, chars.length);
                return;
            }
        }
        SerializeWriter.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeByteArray(byte[] bytes) {
        int quote;
        int bytesLen = bytes.length;
        boolean singleQuote = (this.features & SerializerFeature.UseSingleQuotes.mask) != 0;
        int n = quote = singleQuote ? 39 : 34;
        if (bytesLen == 0) {
            String emptyString = singleQuote ? "''" : "\"\"";
            this.write(emptyString);
            return;
        }
        char[] CA = JSONLexer.CA;
        int eLen = bytesLen / 3 * 3;
        int charsLen = (bytesLen - 1) / 3 + 1 << 2;
        int offset = this.count;
        int newcount = this.count + charsLen + 2;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                int i;
                this.write(quote);
                int s = 0;
                while (s < eLen) {
                    i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
                    this.write(CA[i >>> 18 & 0x3F]);
                    this.write(CA[i >>> 12 & 0x3F]);
                    this.write(CA[i >>> 6 & 0x3F]);
                    this.write(CA[i & 0x3F]);
                }
                int left = bytesLen - eLen;
                if (left > 0) {
                    i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
                    this.write(CA[i >> 12]);
                    this.write(CA[i >>> 6 & 0x3F]);
                    this.write(left == 2 ? CA[i & 0x3F] : 61);
                    this.write(61);
                }
                this.write(quote);
                return;
            }
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        this.buf[offset++] = quote;
        int s = 0;
        int d = offset;
        while (s < eLen) {
            int i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.buf[d++] = CA[i >>> 18 & 0x3F];
            this.buf[d++] = CA[i >>> 12 & 0x3F];
            this.buf[d++] = CA[i >>> 6 & 0x3F];
            this.buf[d++] = CA[i & 0x3F];
        }
        int left = bytesLen - eLen;
        if (left > 0) {
            int i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
            this.buf[newcount - 5] = CA[i >> 12];
            this.buf[newcount - 4] = CA[i >>> 6 & 0x3F];
            this.buf[newcount - 3] = left == 2 ? CA[i & 0x3F] : 61;
            this.buf[newcount - 2] = 61;
        }
        this.buf[newcount - 1] = quote;
    }

    public void writeLong(long i) {
        int newcount;
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            return;
        }
        long val = i < 0L ? -i : i;
        int size = 0;
        long p = 10L;
        for (int j = 1; j < 19; ++j) {
            if (val < p) {
                size = j;
                break;
            }
            p = 10L * p;
        }
        if (size == 0) {
            size = 19;
        }
        if (i < 0L) {
            ++size;
        }
        if ((newcount = this.count + size) > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(newcount);
            } else {
                char[] chars = new char[size];
                SerializeWriter.getChars(i, size, chars);
                this.write(chars, 0, chars.length);
                return;
            }
        }
        SerializeWriter.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeNull() {
        this.write("null");
    }

    protected void writeStringWithDoubleQuote(String text, char seperator, boolean checkSpecial) {
        if (text == null) {
            this.writeNull();
            if (seperator != '\u0000') {
                this.write(seperator);
            }
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (seperator != '\u0000') {
            ++newcount;
        }
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if ((this.features & SerializerFeature.BrowserCompatible.mask) != 0) {
                        if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\"' || ch == '/' || ch == '\\') {
                            this.write(92);
                            this.write(replaceChars[ch]);
                            continue;
                        }
                        if (ch < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(ascii_chars[ch * 2]);
                            this.write(ascii_chars[ch * 2 + 1]);
                            continue;
                        }
                        if (ch >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(DIGITS[ch >>> 12 & 0xF]);
                            this.write(DIGITS[ch >>> 8 & 0xF]);
                            this.write(DIGITS[ch >>> 4 & 0xF]);
                            this.write(DIGITS[ch & 0xF]);
                            continue;
                        }
                    } else if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0 || ch == '/' && (this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0) {
                        this.write(92);
                        this.write(replaceChars[ch]);
                        continue;
                    }
                    this.write(ch);
                }
                this.write(34);
                if (seperator != '\u0000') {
                    this.write(seperator);
                }
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        if ((this.features & SerializerFeature.BrowserCompatible.mask) != 0) {
            char ch;
            int i;
            int lastSpecialIndex = -1;
            for (i = start; i < end; ++i) {
                ch = this.buf[i];
                if (ch == '\"' || ch == '/' || ch == '\\') {
                    lastSpecialIndex = i;
                    ++newcount;
                    continue;
                }
                if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    lastSpecialIndex = i;
                    ++newcount;
                    continue;
                }
                if (ch < ' ') {
                    lastSpecialIndex = i;
                    newcount += 5;
                    continue;
                }
                if (ch < '\u007f') continue;
                lastSpecialIndex = i;
                newcount += 5;
            }
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            for (i = lastSpecialIndex; i >= start; --i) {
                ch = this.buf[i];
                if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = replaceChars[ch];
                    ++end;
                    continue;
                }
                if (ch == '\"' || ch == '/' || ch == '\\') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = ch;
                    ++end;
                    continue;
                }
                if (ch < ' ') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = 117;
                    this.buf[i + 2] = 48;
                    this.buf[i + 3] = 48;
                    this.buf[i + 4] = ascii_chars[ch * 2];
                    this.buf[i + 5] = ascii_chars[ch * 2 + 1];
                    end += 5;
                    continue;
                }
                if (ch < '\u007f') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = 117;
                this.buf[i + 2] = DIGITS[ch >>> 12 & 0xF];
                this.buf[i + 3] = DIGITS[ch >>> 8 & 0xF];
                this.buf[i + 4] = DIGITS[ch >>> 4 & 0xF];
                this.buf[i + 5] = DIGITS[ch & 0xF];
                end += 5;
            }
            if (seperator != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = seperator;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int specialCount = 0;
        int lastSpecialIndex = -1;
        int firstSpecialIndex = -1;
        char lastSpecial = '\u0000';
        if (checkSpecial) {
            for (int i = start; i < end; ++i) {
                char ch = this.buf[i];
                if (ch == '\u2028') {
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    newcount += 4;
                    if (firstSpecialIndex != -1) continue;
                    firstSpecialIndex = i;
                    continue;
                }
                if (ch >= ']') {
                    if (ch < '\u007f' || ch >= '\u00a0') continue;
                    if (firstSpecialIndex == -1) {
                        firstSpecialIndex = i;
                    }
                    ++specialCount;
                    lastSpecialIndex = i;
                    lastSpecial = ch;
                    newcount += 4;
                    continue;
                }
                boolean isSpecial = ch == ' ' ? false : (ch == '/' && (this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? true : (ch > '#' && ch != '\\' ? false : ch <= '\u001f' || ch == '\\' || ch == '\"'));
                if (!isSpecial) continue;
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
                if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] == 4) {
                    newcount += 4;
                }
                if (firstSpecialIndex != -1) continue;
                firstSpecialIndex = i;
            }
            if (specialCount > 0) {
                if ((newcount += specialCount) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                if (specialCount == 1) {
                    if (lastSpecial == '\u2028') {
                        int srcPos = lastSpecialIndex + 1;
                        int destPos = lastSpecialIndex + 6;
                        int LengthOfCopy = end - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                        this.buf[lastSpecialIndex] = 92;
                        this.buf[++lastSpecialIndex] = 117;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 48;
                        this.buf[++lastSpecialIndex] = 50;
                        this.buf[++lastSpecialIndex] = 56;
                    } else {
                        int destPos;
                        int srcPos;
                        char ch = lastSpecial;
                        if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] == 4) {
                            srcPos = lastSpecialIndex + 1;
                            destPos = lastSpecialIndex + 6;
                            int LengthOfCopy = end - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            int bufIndex = lastSpecialIndex;
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch & 0xF];
                        } else {
                            srcPos = lastSpecialIndex + 1;
                            destPos = lastSpecialIndex + 2;
                            int LengthOfCopy = end - lastSpecialIndex - 1;
                            System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                            this.buf[lastSpecialIndex] = 92;
                            this.buf[++lastSpecialIndex] = replaceChars[ch];
                        }
                    }
                } else if (specialCount > 1) {
                    int textIndex = firstSpecialIndex - start;
                    int bufIndex = firstSpecialIndex;
                    for (int i = textIndex; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0 || ch == '/' && (this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0) {
                            this.buf[bufIndex++] = 92;
                            if (specicalFlags_doubleQuotes[ch] == 4) {
                                this.buf[bufIndex++] = 117;
                                this.buf[bufIndex++] = DIGITS[ch >>> 12 & 0xF];
                                this.buf[bufIndex++] = DIGITS[ch >>> 8 & 0xF];
                                this.buf[bufIndex++] = DIGITS[ch >>> 4 & 0xF];
                                this.buf[bufIndex++] = DIGITS[ch & 0xF];
                                end += 5;
                                continue;
                            }
                            this.buf[bufIndex++] = replaceChars[ch];
                            ++end;
                            continue;
                        }
                        if (ch == '\u2028') {
                            this.buf[bufIndex++] = 92;
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = DIGITS[ch & 0xF];
                            end += 5;
                            continue;
                        }
                        this.buf[bufIndex++] = ch;
                    }
                }
            }
        }
        if (seperator != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = seperator;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void write(boolean value) {
        this.write(value ? "true" : "false");
    }

    public void writeString(String text) {
        if ((this.features & SerializerFeature.UseSingleQuotes.mask) != 0) {
            this.writeStringWithSingleQuote(text);
        } else {
            this.writeStringWithDoubleQuote(text, '\u0000', true);
        }
    }

    protected void writeStringWithSingleQuote(String text) {
        char ch;
        int i;
        if (text == null) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = newcount;
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i2 = 0; i2 < text.length(); ++i2) {
                    char ch2 = text.charAt(i2);
                    if (ch2 <= '\r' || ch2 == '\\' || ch2 == '\'' || ch2 == '/' && (this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0) {
                        this.write(92);
                        this.write(replaceChars[ch2]);
                        continue;
                    }
                    this.write(ch2);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        for (i = start; i < end; ++i) {
            ch = this.buf[i];
            if (ch > '\r' && ch != '\\' && ch != '\'' && (ch != '/' || (this.features & SerializerFeature.WriteSlashAsSpecial.mask) == 0)) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = replaceChars[lastSpecial];
            ++end;
            for (i = lastSpecialIndex - 2; i >= start; --i) {
                ch = this.buf[i];
                if (ch > '\r' && ch != '\\' && ch != '\'' && (ch != '/' || (this.features & SerializerFeature.WriteSlashAsSpecial.mask) == 0)) continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = replaceChars[ch];
                ++end;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String key, boolean checkSpecial) {
        if ((this.features & SerializerFeature.UseSingleQuotes.mask) != 0) {
            if ((this.features & SerializerFeature.QuoteFieldNames.mask) != 0) {
                this.writeStringWithSingleQuote(key);
                this.write(58);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(key);
            }
        } else if ((this.features & SerializerFeature.QuoteFieldNames.mask) != 0) {
            this.writeStringWithDoubleQuote(key, ':', checkSpecial);
        } else {
            this.writeKeyWithDoubleQuoteIfHasSpecial(key);
        }
    }

    private void writeKeyWithDoubleQuoteIfHasSpecial(String text) {
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                char ch;
                int i;
                if (len == 0) {
                    this.write(34);
                    this.write(34);
                    this.write(58);
                    return;
                }
                boolean hasSpecial = false;
                for (i = 0; i < len; ++i) {
                    ch = text.charAt(i);
                    if (ch >= specicalFlags_doubleQuotes.length || specicalFlags_doubleQuotes[ch] == 0) continue;
                    hasSpecial = true;
                    break;
                }
                if (hasSpecial) {
                    this.write(34);
                }
                for (i = 0; i < len; ++i) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] != 0) {
                        this.write(92);
                        this.write(replaceChars[ch]);
                        continue;
                    }
                    this.write(ch);
                }
                if (hasSpecial) {
                    this.write(34);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(newcount);
        }
        if (len == 0) {
            int newCount = this.count + 3;
            if (newCount > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 34;
            this.buf[this.count++] = 34;
            this.buf[this.count++] = 58;
            return;
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_doubleQuotes.length || specicalFlags_doubleQuotes[ch] == 0) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 34;
                this.buf[++i] = 92;
                this.buf[++i] = replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 34;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String text) {
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            if (this.writer != null) {
                char ch;
                int i;
                if (len == 0) {
                    this.write(39);
                    this.write(39);
                    this.write(58);
                    return;
                }
                boolean hasSpecial = false;
                for (i = 0; i < len; ++i) {
                    ch = text.charAt(i);
                    if (ch >= specicalFlags_singleQuotes.length || specicalFlags_singleQuotes[ch] == 0) continue;
                    hasSpecial = true;
                    break;
                }
                if (hasSpecial) {
                    this.write(39);
                }
                for (i = 0; i < len; ++i) {
                    ch = text.charAt(i);
                    if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] != 0) {
                        this.write(92);
                        this.write(replaceChars[ch]);
                        continue;
                    }
                    this.write(ch);
                }
                if (hasSpecial) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(newcount);
        }
        if (len == 0) {
            int newCount = this.count + 3;
            if (newCount > this.buf.length) {
                this.expandCapacity(this.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_singleQuotes.length || specicalFlags_singleQuotes[ch] == 0) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 39;
                this.buf[++i] = 92;
                this.buf[++i] = replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 39;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = replaceChars[ch];
            ++end;
        }
        this.buf[newcount - 1] = 58;
    }

    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
            this.count = 0;
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    protected static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static {
        int i;
        bufLocal = new ThreadLocal();
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        ascii_chars = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        replaceChars = new char[93];
        SerializeWriter.specicalFlags_doubleQuotes[0] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[1] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[2] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[3] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[4] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[5] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[6] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[7] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[8] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[9] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[10] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[11] = 4;
        SerializeWriter.specicalFlags_doubleQuotes[12] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[13] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[34] = 1;
        SerializeWriter.specicalFlags_doubleQuotes[92] = 1;
        SerializeWriter.specicalFlags_singleQuotes[0] = 4;
        SerializeWriter.specicalFlags_singleQuotes[1] = 4;
        SerializeWriter.specicalFlags_singleQuotes[2] = 4;
        SerializeWriter.specicalFlags_singleQuotes[3] = 4;
        SerializeWriter.specicalFlags_singleQuotes[4] = 4;
        SerializeWriter.specicalFlags_singleQuotes[5] = 4;
        SerializeWriter.specicalFlags_singleQuotes[6] = 4;
        SerializeWriter.specicalFlags_singleQuotes[7] = 4;
        SerializeWriter.specicalFlags_singleQuotes[8] = 1;
        SerializeWriter.specicalFlags_singleQuotes[9] = 1;
        SerializeWriter.specicalFlags_singleQuotes[10] = 1;
        SerializeWriter.specicalFlags_singleQuotes[11] = 4;
        SerializeWriter.specicalFlags_singleQuotes[12] = 1;
        SerializeWriter.specicalFlags_singleQuotes[13] = 1;
        SerializeWriter.specicalFlags_singleQuotes[92] = 1;
        SerializeWriter.specicalFlags_singleQuotes[39] = 1;
        for (i = 14; i <= 31; ++i) {
            SerializeWriter.specicalFlags_doubleQuotes[i] = 4;
            SerializeWriter.specicalFlags_singleQuotes[i] = 4;
        }
        for (i = 127; i < 160; ++i) {
            SerializeWriter.specicalFlags_doubleQuotes[i] = 4;
            SerializeWriter.specicalFlags_singleQuotes[i] = 4;
        }
        SerializeWriter.replaceChars[0] = 48;
        SerializeWriter.replaceChars[1] = 49;
        SerializeWriter.replaceChars[2] = 50;
        SerializeWriter.replaceChars[3] = 51;
        SerializeWriter.replaceChars[4] = 52;
        SerializeWriter.replaceChars[5] = 53;
        SerializeWriter.replaceChars[6] = 54;
        SerializeWriter.replaceChars[7] = 55;
        SerializeWriter.replaceChars[8] = 98;
        SerializeWriter.replaceChars[9] = 116;
        SerializeWriter.replaceChars[10] = 110;
        SerializeWriter.replaceChars[11] = 118;
        SerializeWriter.replaceChars[12] = 102;
        SerializeWriter.replaceChars[13] = 114;
        SerializeWriter.replaceChars[34] = 34;
        SerializeWriter.replaceChars[39] = 39;
        SerializeWriter.replaceChars[47] = 47;
        SerializeWriter.replaceChars[92] = 92;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

