/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaBeanInfo {
    final Constructor<?> defaultConstructor;
    final int defaultConstructorParameterSize;
    final Constructor<?> creatorConstructor;
    final Method factoryMethod;
    final FieldInfo[] fields;
    final FieldInfo[] sortedFields;
    final JSONType jsonType;
    boolean ordered = false;
    final boolean supportBeanToArray;
    public final String typeName;
    public final String typeKey;
    public final int parserFeatures;

    JavaBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, FieldInfo[] fields, FieldInfo[] sortedFields, JSONType jsonType) {
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.fields = fields;
        this.jsonType = jsonType;
        int parserFeatures = 0;
        if (jsonType != null) {
            String typeName = jsonType.typeName();
            this.typeName = typeName.length() > 0 ? typeName : clazz.getName();
            String typeKey = jsonType.typeKey();
            this.typeKey = typeKey.length() > 0 ? typeKey : null;
            Feature[] featureArray = jsonType.parseFeatures();
            int n = featureArray.length;
            for (int i = 0; i < n; ++i) {
                Feature feature = featureArray[i];
                parserFeatures |= feature.mask;
            }
        } else {
            this.typeName = clazz.getName();
            this.typeKey = null;
        }
        this.parserFeatures = parserFeatures;
        boolean supportBeanToArray = false;
        if (jsonType != null) {
            for (Feature feature : jsonType.parseFeatures()) {
                if (feature != Feature.SupportArrayToBean) continue;
                supportBeanToArray = true;
            }
        }
        this.supportBeanToArray = supportBeanToArray;
        FieldInfo[] fieldInfoArray = this.sortedFields = Arrays.equals(fields, sortedFields = this.computeSortedFields(fields, sortedFields)) ? fields : sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : (factoryMethod != null ? factoryMethod.getParameterTypes().length : 0);
    }

    private FieldInfo[] computeSortedFields(FieldInfo[] fields, FieldInfo[] sortedFields) {
        if (this.jsonType == null) {
            return sortedFields;
        }
        String[] orders = this.jsonType.orders();
        if (orders != null && orders.length != 0) {
            int i;
            int i2;
            int j;
            boolean containsAll = true;
            for (int i3 = 0; i3 < orders.length; ++i3) {
                boolean got = false;
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i3])) continue;
                    got = true;
                    break;
                }
                if (got) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                return sortedFields;
            }
            if (orders.length == fields.length) {
                boolean orderMatch = true;
                for (i2 = 0; i2 < orders.length; ++i2) {
                    if (sortedFields[i2].name.equals(orders[i2])) continue;
                    orderMatch = false;
                    break;
                }
                if (orderMatch) {
                    return sortedFields;
                }
                FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
                block3: for (i = 0; i < orders.length; ++i) {
                    for (int j2 = 0; j2 < sortedFields.length; ++j2) {
                        if (!sortedFields[j2].name.equals(orders[i])) continue;
                        newSortedFields[i] = sortedFields[j2];
                        continue block3;
                    }
                }
                sortedFields = newSortedFields;
                this.ordered = true;
                return newSortedFields;
            }
            FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
            block5: for (i2 = 0; i2 < orders.length; ++i2) {
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i2])) continue;
                    newSortedFields[i2] = sortedFields[j];
                    continue block5;
                }
            }
            int fieldIndex = orders.length;
            for (i = 0; i < sortedFields.length; ++i) {
                boolean contains = false;
                for (int j3 = 0; j3 < newSortedFields.length && j3 < fieldIndex; ++j3) {
                    if (!newSortedFields[i].equals(sortedFields[j3])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                newSortedFields[fieldIndex] = sortedFields[i];
                ++fieldIndex;
            }
            this.ordered = true;
        }
        return sortedFields;
    }

    static boolean addField(List<FieldInfo> fields, FieldInfo field, boolean fieldOnly) {
        if (!fieldOnly) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = fields.get(i);
                if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
                return false;
            }
        }
        fields.add(field);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static JavaBeanInfo build(Class<?> clazz, int classModifiers, Type type, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport, PropertyNamingStrategy propertyNamingStrategy) {
        void var17_28;
        void var19_52;
        boolean isInterfaceOrAbstract;
        Method[] methods;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        HashMap classFieldCache = new HashMap();
        Constructor<?> defaultConstructor = null;
        if ((classModifiers & 0x400) == 0) {
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                    defaultConstructor = constructor;
                    break;
                }
            }
        }
        Executable creatorConstructor = null;
        Method factoryMethod = null;
        if (fieldOnly) {
            methods = null;
        } else {
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Class<?> cls = clazz; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                Executable[] declaredMethods = cls.getDeclaredMethods();
                Method[] methodArray = declaredMethods;
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method method = methodArray[i];
                    int n2 = method.getModifiers();
                    if ((n2 & 8) != 0) {
                        if (!method.isAnnotationPresent(JSONCreator.class)) continue;
                        if (factoryMethod != null) {
                            throw new JSONException("multi-json creator");
                        }
                        factoryMethod = method;
                        continue;
                    }
                    if ((n2 & 2) != 0 || (n2 & 0x100) != 0 || (n2 & 4) != 0) continue;
                    methodList.add(method);
                }
            }
            methods = new Method[methodList.size()];
            methodList.toArray(methods);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        boolean bl = isInterfaceOrAbstract = clazz.isInterface() || (classModifiers & 0x400) != 0;
        if (defaultConstructor == null || isInterfaceOrAbstract) {
            JSONType jsonType;
            JSONField fieldAnnotation;
            int i;
            GenericDeclaration[] parameterTypes;
            creatorConstructor = null;
            for (Executable executable : clazz.getDeclaredConstructors()) {
                JSONCreator annotation = ((Constructor)executable).getAnnotation(JSONCreator.class);
                if (annotation == null) continue;
                if (creatorConstructor != null) {
                    throw new JSONException("multi-json creator");
                }
                creatorConstructor = executable;
                break;
            }
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(clazz, creatorConstructor, classModifiers);
                parameterTypes = ((Constructor)creatorConstructor).getParameterTypes();
                Object[] objectArray = fieldGenericSupport ? ((Constructor)creatorConstructor).getGenericParameterTypes() : parameterTypes;
                for (i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] annotationArray = ((Constructor)creatorConstructor).getParameterAnnotations()[i];
                    fieldAnnotation = null;
                    for (Annotation paramAnnotation : annotationArray) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    GenericDeclaration genericDeclaration = parameterTypes[i];
                    Object fieldType = objectArray[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields, classFieldCache);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, classModifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, (Class<?>)genericDeclaration, (Type)fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                }
                FieldInfo[] fields = new FieldInfo[fieldList.size()];
                fieldList.toArray(fields);
                Object[] objectArray2 = new FieldInfo[fields.length];
                System.arraycopy(fields, 0, objectArray2, 0, fields.length);
                Arrays.sort(objectArray2);
                jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                return new JavaBeanInfo(clazz, null, (Constructor<?>)creatorConstructor, null, fields, (FieldInfo[])objectArray2, jsonType);
            }
            if (factoryMethod != null) {
                TypeUtils.setAccessible(clazz, factoryMethod, classModifiers);
                parameterTypes = factoryMethod.getParameterTypes();
                if (parameterTypes.length > 0) {
                    void var19_49;
                    Object[] objectArray = fieldGenericSupport ? factoryMethod.getGenericParameterTypes() : parameterTypes;
                    for (i = 0; i < parameterTypes.length; ++i) {
                        Annotation[] annotationArray = factoryMethod.getParameterAnnotations()[i];
                        fieldAnnotation = null;
                        for (Annotation paramAnnotation : annotationArray) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        if (fieldAnnotation == null) {
                            throw new JSONException("illegal json creator");
                        }
                        GenericDeclaration genericDeclaration = parameterTypes[i];
                        Object fieldType = objectArray[i];
                        Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields, classFieldCache);
                        int ordinal = fieldAnnotation.ordinal();
                        int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, (Class<?>)genericDeclaration, (Type)fieldType, field, ordinal, serialzeFeatures);
                        JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                    }
                    Object[] fields = new FieldInfo[fieldList.size()];
                    fieldList.toArray(fields);
                    Object[] objectArray3 = new FieldInfo[fields.length];
                    System.arraycopy(fields, 0, objectArray3, 0, fields.length);
                    Arrays.sort(objectArray3);
                    if (Arrays.equals(fields, objectArray3)) {
                        Object[] objectArray4 = fields;
                    }
                    jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                    JavaBeanInfo javaBeanInfo = new JavaBeanInfo(clazz, null, null, factoryMethod, (FieldInfo[])fields, (FieldInfo[])var19_49, jsonType);
                    return javaBeanInfo;
                }
            } else if (!isInterfaceOrAbstract) {
                throw new JSONException("default constructor not found. " + clazz);
            }
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, classModifiers);
        }
        if (!fieldOnly) {
            for (Method method : methods) {
                String propertyName;
                JSONField annotation;
                Class<?> returnType;
                int ordinal = 0;
                int n = 0;
                String methodName = method.getName();
                if (methodName.length() < 4 || (returnType = method.getReturnType()) != Void.TYPE && returnType != method.getDeclaringClass() || method.getParameterTypes().length != 1) continue;
                JSONField jSONField = annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                if (annotation == null && jsonFieldSupport) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    n = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName2 = annotation.name();
                        JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, n, annotation, null, fieldGenericSupport), fieldOnly);
                        TypeUtils.setAccessible(clazz, method, classModifiers);
                        continue;
                    }
                }
                if (!methodName.startsWith("set")) continue;
                char c3 = methodName.charAt(3);
                if (Character.isUpperCase(c3)) {
                    propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                } else if (c3 == '_') {
                    propertyName = methodName.substring(4);
                } else if (c3 == 'f') {
                    propertyName = methodName.substring(3);
                } else {
                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                }
                Field field = TypeUtils.getField(clazz, propertyName, declaredFields, classFieldCache);
                if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                    String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    field = TypeUtils.getField(clazz, isFieldName, declaredFields, classFieldCache);
                }
                if (field != null) {
                    JSONField fieldAnnotation;
                    JSONField jSONField2 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                    if (fieldAnnotation != null) {
                        ordinal = fieldAnnotation.ordinal();
                        n = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName = fieldAnnotation.name();
                            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, n, annotation, fieldAnnotation, fieldGenericSupport), fieldOnly);
                            continue;
                        }
                        if (annotation == null) {
                            annotation = fieldAnnotation;
                        }
                    }
                }
                if (propertyNamingStrategy != null) {
                    propertyName = propertyNamingStrategy.translate(propertyName);
                }
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, n, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        ArrayList<Field> classfields = new ArrayList<Field>(declaredFields.length);
        Field[] fieldArray = declaredFields;
        int fields = fieldArray.length;
        boolean bl2 = false;
        while (var19_52 < fields) {
            block63: {
                Field f;
                block64: {
                    boolean supportReadOnly;
                    f = fieldArray[var19_52];
                    int n = f.getModifiers();
                    if ((n & 8) != 0) break block63;
                    if ((n & 0x10) == 0) break block64;
                    Class<?> fieldType = f.getType();
                    boolean bl3 = supportReadOnly = Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType);
                    if (!supportReadOnly) break block63;
                }
                if ((f.getModifiers() & 1) != 0) {
                    classfields.add(f);
                }
            }
            ++var19_52;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        while (var17_28 != null && var17_28 != Object.class) {
            for (Field field : var17_28.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if ((modifiers & 8) != 0) continue;
                if ((modifiers & 0x10) != 0) {
                    boolean supportReadOnly;
                    Class<?> fieldType = field.getType();
                    boolean bl4 = supportReadOnly = Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType);
                    if (!supportReadOnly) continue;
                }
                if ((modifiers & 1) == 0) continue;
                classfields.add(field);
            }
            Class clazz3 = var17_28.getSuperclass();
        }
        for (Field field : classfields) {
            JSONField fieldAnnotation;
            int n;
            String string = field.getName();
            boolean contains = false;
            int size = fieldList.size();
            for (n = 0; n < size; ++n) {
                FieldInfo item = (FieldInfo)fieldList.get(n);
                if (!item.name.equals(string)) continue;
                contains = true;
            }
            if (contains) continue;
            n = 0;
            int serialzeFeatures = 0;
            String propertyName = string;
            JSONField jSONField = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
            if (fieldAnnotation != null) {
                n = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            TypeUtils.setAccessible(clazz, field, classModifiers);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, null, field, clazz, type, n, serialzeFeatures, null, fieldAnnotation, fieldGenericSupport), fieldOnly);
        }
        if (!fieldOnly) {
            void var19_56;
            Method[] methodArray = methods;
            int field = methodArray.length;
            boolean bl5 = false;
            while (var19_56 < field) {
                Class<?> methodReturnType;
                Method method = methodArray[var19_56];
                String string = method.getName();
                if (string.length() >= 4 && string.startsWith("get") && Character.isUpperCase(string.charAt(3)) && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(methodReturnType = method.getReturnType()) || Map.class.isAssignableFrom(methodReturnType))) {
                    String annotationName;
                    JSONField annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                    String propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(string.charAt(3)) + string.substring(4);
                    JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, 0, 0, annotation, null, fieldGenericSupport), fieldOnly);
                    TypeUtils.setAccessible(clazz, method, classModifiers);
                }
                ++var19_56;
            }
        }
        FieldInfo[] fieldInfoArray = new FieldInfo[fieldList.size()];
        fieldList.toArray(fieldInfoArray);
        Object[] sortedFields = new FieldInfo[fieldInfoArray.length];
        System.arraycopy(fieldInfoArray, 0, sortedFields, 0, fieldInfoArray.length);
        Arrays.sort(sortedFields);
        JSONType jSONType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
        return new JavaBeanInfo(clazz, defaultConstructor, null, factoryMethod, fieldInfoArray, (FieldInfo[])sortedFields, jSONType);
    }
}

