/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MiscCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final MiscCodec instance = new MiscCodec();

    private MiscCodec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            if (fieldType == Character.TYPE || fieldType == Character.class) {
                serializer.write("");
            } else {
                Class<?> fieldClass;
                if ((out.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0 && Enumeration.class.isAssignableFrom(fieldClass = TypeUtils.getClass(fieldType))) {
                    out.write("[]");
                    return;
                }
                out.writeNull();
            }
            return;
        }
        if (object instanceof Pattern) {
            Pattern p = (Pattern)object;
            serializer.write(p.pattern());
        } else if (object instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)object;
            serializer.write(timeZone.getID());
        } else if (object instanceof Currency) {
            Currency currency = (Currency)object;
            serializer.write(currency.getCurrencyCode());
        } else if (object instanceof Class) {
            Class clazz = (Class)object;
            serializer.write(clazz.getName());
        } else if (object instanceof Character) {
            Character value = (Character)object;
            char c = value.charValue();
            if (c == '\u0000') {
                serializer.write("\u0000");
            } else {
                serializer.write(value.toString());
            }
        } else if (object instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)object).toPattern();
            if ((out.features & SerializerFeature.WriteClassName.mask) != 0 && object.getClass() != fieldType) {
                out.write(123);
                out.writeFieldName("@type", false);
                serializer.write(object.getClass().getName());
                out.write(44);
                out.writeFieldName("val", false);
                out.writeString(pattern);
                out.write(125);
                return;
            }
            out.writeString(pattern);
        } else if (object instanceof JSONStreamAware) {
            JSONStreamAware aware = (JSONStreamAware)object;
            aware.writeJSONString(serializer.out);
        } else if (object instanceof JSONAware) {
            JSONAware aware = (JSONAware)object;
            out.write(aware.toJSONString());
        } else if (object instanceof JSONSerializable) {
            JSONSerializable jsonSerializable = (JSONSerializable)object;
            jsonSerializable.write(serializer, fieldName, fieldType);
        } else if (object instanceof Enumeration) {
            Type elementType = null;
            if ((out.features & SerializerFeature.WriteClassName.mask) != 0 && fieldType instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)fieldType;
                elementType = param.getActualTypeArguments()[0];
            }
            Enumeration e = (Enumeration)object;
            SerialContext context = serializer.context;
            serializer.setContext(context, object, fieldName, 0);
            try {
                int i = 0;
                out.write(91);
                while (e.hasMoreElements()) {
                    Object item = e.nextElement();
                    if (i++ != 0) {
                        out.write(44);
                    }
                    if (item == null) {
                        out.writeNull();
                        continue;
                    }
                    Class<?> clazz = item.getClass();
                    ObjectSerializer itemSerializer = serializer.config.get(clazz);
                    itemSerializer.write(serializer, item, i - 1, elementType);
                }
                out.write(93);
            }
            finally {
                serializer.context = context;
            }
        } else {
            serializer.write(object.toString());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object objVal;
        if (clazz == StackTraceElement.class) {
            return this.parseStackTraceElement(parser);
        }
        JSONLexer lexer = parser.lexer;
        if (parser.resolveStatus == 2) {
            parser.resolveStatus = 0;
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            objVal = parser.parse();
            parser.accept(13);
        } else {
            objVal = parser.parse();
        }
        if (objVal == null) {
            return null;
        }
        if (!(objVal instanceof String)) {
            throw new JSONException("except string value");
        }
        String strVal = (String)objVal;
        if (strVal.length() == 0) {
            return null;
        }
        if (clazz == UUID.class) {
            return (T)UUID.fromString(strVal);
        }
        if (clazz == Class.class) {
            return (T)TypeUtils.loadClass(strVal, parser.config.defaultClassLoader);
        }
        if (clazz == Locale.class) {
            String[] items = strVal.split("_");
            if (items.length == 1) {
                return (T)new Locale(items[0]);
            }
            if (items.length == 2) {
                return (T)new Locale(items[0], items[1]);
            }
            return (T)new Locale(items[0], items[1], items[2]);
        }
        if (clazz == URI.class) {
            return (T)URI.create(strVal);
        }
        if (clazz == URL.class) {
            try {
                return (T)new URL(strVal);
            }
            catch (MalformedURLException e) {
                throw new JSONException("create url error", e);
            }
        }
        if (clazz == Pattern.class) {
            return (T)Pattern.compile(strVal);
        }
        if (clazz == Charset.class) {
            return (T)Charset.forName(strVal);
        }
        if (clazz == Currency.class) {
            return (T)Currency.getInstance(strVal);
        }
        if (clazz == SimpleDateFormat.class) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(strVal, parser.lexer.locale);
            dateFormat.setTimeZone(parser.lexer.timeZone);
            return (T)dateFormat;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return (T)TypeUtils.castToChar(strVal);
        }
        return (T)TimeZone.getTimeZone(strVal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T parseStackTraceElement(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error: " + JSONToken.name(lexer.token()));
        }
        String declaringClass = null;
        String methodName = null;
        String fileName = null;
        int lineNumber = 0;
        while (true) {
            String key;
            if ((key = lexer.scanSymbol(parser.symbolTable)) == null) {
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
                }
                if (lexer.token() == 16) continue;
            }
            lexer.nextTokenWithChar(':');
            if ("className".equals(key)) {
                if (lexer.token() == 8) {
                    declaringClass = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    declaringClass = lexer.stringVal();
                }
            } else if ("methodName".equals(key)) {
                if (lexer.token() == 8) {
                    methodName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    methodName = lexer.stringVal();
                }
            } else if ("fileName".equals(key)) {
                if (lexer.token() == 8) {
                    fileName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    fileName = lexer.stringVal();
                }
            } else if ("lineNumber".equals(key)) {
                if (lexer.token() == 8) {
                    lineNumber = 0;
                } else {
                    if (lexer.token() != 2) throw new JSONException("syntax error");
                    lineNumber = lexer.intValue();
                }
            } else if ("nativeMethod".equals(key)) {
                if (lexer.token() == 8) {
                    lexer.nextToken(16);
                } else if (lexer.token() == 6) {
                    lexer.nextToken(16);
                } else {
                    if (lexer.token() != 7) throw new JSONException("syntax error");
                    lexer.nextToken(16);
                }
            } else {
                if (key != "@type") throw new JSONException("syntax error : " + key);
                if (lexer.token() == 4) {
                    String elementType = lexer.stringVal();
                    if (!elementType.equals("java.lang.StackTraceElement")) {
                        throw new JSONException("syntax error : " + elementType);
                    }
                } else if (lexer.token() != 8) {
                    throw new JSONException("syntax error");
                }
            }
            if (lexer.token() == 13) break;
        }
        lexer.nextToken(16);
        return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }
}

