/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import java.io.IOException;
import java.lang.reflect.Member;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldSerializer
implements Comparable<FieldSerializer> {
    public final FieldInfo fieldInfo;
    protected final boolean writeNull;
    protected final int features;
    protected final String format;
    private RuntimeSerializerInfo runtimeInfo;

    public FieldSerializer(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        boolean writeNull = false;
        JSONField annotation = fieldInfo.getAnnotation();
        String format = null;
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature != SerializerFeature.WriteMapNullValue) continue;
                writeNull = true;
            }
            format = annotation.format();
            if ((format = format.trim()).length() == 0) {
                format = null;
            }
            this.features = SerializerFeature.of(annotation.serialzeFeatures());
        } else {
            this.features = 0;
        }
        this.writeNull = writeNull;
        this.format = format;
    }

    public void writePrefix(JSONSerializer serializer) throws IOException {
        SerializeWriter out = serializer.out;
        int featurs = out.features;
        if ((featurs & SerializerFeature.QuoteFieldNames.mask) != 0) {
            if ((featurs & SerializerFeature.UseSingleQuotes.mask) != 0) {
                out.writeFieldName(this.fieldInfo.name, true);
            } else {
                out.write(this.fieldInfo.name_chars, 0, this.fieldInfo.name_chars.length);
            }
        } else {
            out.writeFieldName(this.fieldInfo.name, true);
        }
    }

    public Object getPropertyValue(Object object) throws Exception {
        try {
            return this.fieldInfo.get(object);
        }
        catch (Exception ex) {
            Member member = (Member)((Object)(this.fieldInfo.method != null ? this.fieldInfo.method : this.fieldInfo.field));
            String qualifiedName = member.getDeclaringClass().getName() + "." + member.getName();
            throw new JSONException("get property error\u3002 " + qualifiedName, ex);
        }
    }

    public void writeValue(JSONSerializer serializer, Object propertyValue) throws Exception {
        if (this.format != null) {
            serializer.writeWithFormat(propertyValue, this.format);
            return;
        }
        if (this.runtimeInfo == null) {
            Class<?> runtimeFieldClass = propertyValue == null ? this.fieldInfo.fieldClass : propertyValue.getClass();
            ObjectSerializer fieldSerializer = serializer.config.get(runtimeFieldClass);
            this.runtimeInfo = new RuntimeSerializerInfo(fieldSerializer, runtimeFieldClass);
        }
        RuntimeSerializerInfo runtimeInfo = this.runtimeInfo;
        if (propertyValue == null) {
            if ((this.features & SerializerFeature.WriteNullNumberAsZero.mask) != 0 && Number.class.isAssignableFrom(runtimeInfo.runtimeFieldClass)) {
                serializer.out.write(48);
                return;
            }
            if ((this.features & SerializerFeature.WriteNullBooleanAsFalse.mask) != 0 && Boolean.class == runtimeInfo.runtimeFieldClass) {
                serializer.out.write("false");
                return;
            }
            if ((this.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0 && Collection.class.isAssignableFrom(runtimeInfo.runtimeFieldClass)) {
                serializer.out.write("[]");
                return;
            }
            runtimeInfo.fieldSerializer.write(serializer, null, this.fieldInfo.name, runtimeInfo.runtimeFieldClass);
            return;
        }
        Class<?> valueClass = propertyValue.getClass();
        if (valueClass == runtimeInfo.runtimeFieldClass) {
            runtimeInfo.fieldSerializer.write(serializer, propertyValue, this.fieldInfo.name, this.fieldInfo.fieldType);
            return;
        }
        ObjectSerializer valueSerializer = serializer.config.get(valueClass);
        valueSerializer.write(serializer, propertyValue, this.fieldInfo.name, this.fieldInfo.fieldType);
    }

    @Override
    public int compareTo(FieldSerializer o) {
        return this.fieldInfo.compareTo(o.fieldInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RuntimeSerializerInfo {
        ObjectSerializer fieldSerializer;
        Class<?> runtimeFieldClass;

        public RuntimeSerializerInfo(ObjectSerializer fieldSerializer, Class<?> runtimeFieldClass) {
            this.fieldSerializer = fieldSerializer;
            this.runtimeFieldClass = runtimeFieldClass;
        }
    }
}

